<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                
                <div class="panel_s tw-mt-2">
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table dt-table table-assignments">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th><?php echo _l('hr_assignment_title'); ?></th>
                                    <th><?php echo _l('hr_assignment_description'); ?></th>
                                    <th><?php echo _l('hr_status'); ?></th>
                                    <th><?php echo _l('hr_submitted_at'); ?></th>
                                    <th></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($assignments as $row) { ?>
                                    <tr>
                                        <td><?php echo e($row['id']); ?></td>
                                        <td><?php echo e($row['title']); ?></td>
                                        <td><?php echo e($row['description']); ?></td>
                                        <td>
                                            <?php if ($row['status'] == 'pending') { ?>
                                                <span class="label label-warning"><?php echo _l('hr_status_pending'); ?></span>
                                            <?php } elseif ($row['status'] == 'submitted') { ?>
                                                <span class="label label-info"><?php echo _l('hr_status_submitted'); ?></span>
                                            <?php } elseif ($row['status'] == 'approved') { ?>
                                                <span class="label label-success"><?php echo _l('hr_status_approved'); ?></span>
                                            <?php } elseif ($row['status'] == 'rejected') { ?>
                                                <span class="label label-danger"><?php echo _l('hr_status_rejected'); ?></span>
                                            <?php } ?>
                                        </td>
                                        <td><?php echo e($row['submitted_at'] ? _d($row['submitted_at']) : '-'); ?></td>
                                        <td class="text-right">
                                            <?php if ($row['status'] == 'pending') { ?>
                                                <a href="<?php echo site_url('hr/candidate_login/submit_assignment/' . $row['id']); ?>" class="btn btn-primary btn-icon" title="<?php echo _l('hr_submit_assignment'); ?>"><i class="fa-regular fa-upload"></i></a>
                                            <?php } ?>
                                            <?php if ($row['file_path']) { ?>
                                                <a href="<?php echo site_url('hr/candidate_login/download_assignment/' . $row['id']); ?>" class="btn btn-info btn-icon" title="<?php echo _l('download'); ?>"><i class="fa-regular fa-download"></i></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
