<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<style>
    .input-group-text {
    font-weight: 500;
    border-left: 0;
}
.input-group {
    display: flex;
}
.input-group-append {
    text-align: center;  
    padding: 5px;
    border: 1px solid #ced4da;
    background-color: #b0b6bd;
    border-radius: 0px 5px 5px 0px
}    
</style>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <?php echo form_open_multipart(); ?>
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="tab-content tw-mt-3">
                            <div role="tabpanel" class="tab-pane active" id="tab_candidate_info">
                                <div class="row">
                                    <div class="col-md-12">
                                        <span><b>Name: </b><?php echo isset($candidate) ? ($candidate->first_name.' '.$candidate->last_name) : 'Manya Gupta'; ?></span><br/>
                                        <span><b>Phone: </b><?php echo isset($candidate) ? $candidate->phone : '+91 12345 67890'; ?></span><br/>
                                        <span><b>Email: </b><?php echo isset($candidate) ? $candidate->email : 'manyagupta@gmail.com'; ?></span><br/>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="resume" class="control-label"><?= _l('resume'); ?></label>
                                            <input type="file" name="resume" class="form-control" id="resume">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_date_input('valid_date', _l('Valid Through'), isset($candidate) ? $candidate->valid_date : ''); ?>
                                        <?php // echo render_input('resume', _l('hr_candidate_resume'), isset($candidate) ? $candidate->resume : ''); ?>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <?php echo render_date_input('date_of_birth', _l('Date of Birth'), isset($candidate) ? $candidate->date_of_birth : ''); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_select('contract_type', [
                                                ['id' => 'hourly', 'name' => _l('Hourly')],
                                                ['id' => 'weekly', 'name' => _l('Weekly')],
                                                ['id' => 'monthly', 'name' => _l('Monthly')]
                                            ], ['id', 'name'], _l('Contract Type'), isset($candidate) ? $candidate->contract_type : 'freelancer'); ?>
                                    </div>
                                </div>
                                <!-- <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="experience">Experience</label>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="input-group">
                                                        <input type="number" min="0" class="form-control" name="experience_years" id="experience_years" placeholder="0">
                                                        <div class="input-group-append">
                                                            <span class="input-group-text">Years</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 mt-2 mt-md-0">
                                                    <div class="input-group">
                                                        <input type="number" min="0" max="11" class="form-control" name="experience_month" id="experience_month" placeholder="0">
                                                        <div class="input-group-append">
                                                            <span class="input-group-text">Months</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_select('preferred_job_type', [
                                                ['id' => 'freelancer', 'name' => _l('Freelancer')],
                                                ['id' => 'regular', 'name' => _l('Regular')]
                                            ], ['id', 'name'], _l('Preferred Job Type'), isset($candidate) ? $candidate->preferred_job_type : 'freelancer'); ?>
                                    </div>
                                </div> -->
                                   
                                <?php if (!isset($candidate) || $candidate->employee_type != 'intern'): ?>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="experience">Experience</label>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="input-group">
                                                            <input type="number" min="0" class="form-control" name="experience_years" id="experience_years" placeholder="0">
                                                            <div class="input-group-append">
                                                                <span class="input-group-text">Years</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mt-2 mt-md-0">
                                                        <div class="input-group">
                                                            <input type="number" min="0" max="11" class="form-control" name="experience_month" id="experience_month" placeholder="0">
                                                            <div class="input-group-append">
                                                                <span class="input-group-text">Months</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <?php echo render_select('preferred_job_type', [
                                                    ['id' => 'freelancer', 'name' => _l('Freelancer')],
                                                    ['id' => 'regular', 'name' => _l('Regular')]
                                                ], ['id', 'name'], _l('Preferred Job Type'), isset($candidate) ? $candidate->preferred_job_type : 'freelancer'); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>


                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="rate"> <span class="text-danger">*</span> Rate</label>
                                            <div class="d-flex" style="display: flex;">
                                                <!-- Currency dropdown -->
                                                <select class="form-control w-auto mr-2" name="rate_currency" id="rate_currency">
                                                    <option value="INR">INR</option>
                                                    <option value="USD">USD</option>
                                                    <option value="EUR">EUR</option>
                                                </select>

                                                <!-- Amount input -->
                                                <input type="number" class="form-control mr-2" name="rate" id="rate" placeholder="0.00" min="0" step="0.01">

                                                <!-- Duration dropdown -->
                                                <select class="form-control w-auto" name="rate_type" id="rate_type">
                                                    <option value="Hour">Hour</option>
                                                    <option value="Day">Day</option>
                                                    <option value="Month">Month</option>
                                                </select>
                                            </div>
                                        </div>  
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <?php echo render_select('contract_template', $contract_template, ['id', 'title'], _l('Contract Template'), isset($candidate) ? $candidate->contract_template : ''); ?>
                                    </div>
                                </div>
                                <div class="row">
                                    
                                    <div class="col-md-6">
                                        <?php echo render_textarea('address', _l('Address'), isset($candidate) ? $candidate->address : '', ['rows' => 4]); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="template_type"> <span class="text-danger">*</span> Template Type</label>
                                        <select class="form-control w-auto" name="template_type" id="template_type">
                                            <option value="intern">Intern</option>
                                            <option value="employment">Employment</option>
                                            <option value="nda">NDA</option>
                                            <option value="create">Create +</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel-footer text-right">
                        <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                        <a href="<?php echo admin_url('hr/candidate'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
