<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Candidate extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        if (!is_admin()) {
            access_denied('hr');
        }
        $this->load->model('hr/candidate_model');
        $this->load->model('hr/contract_template_model');
        $this->load->model('hr/certificate_template_model');
        $this->load->model('staff_model');
        $this->load->model('Candidate_contract_model');

    }

    public function index()
    {
        $filters = [
            'candidate_type' => $this->input->get('candidate_type'),
            'status' => $this->input->get('status'),
            'search' => $this->input->get('search')
        ];
        
        $data['title'] = _l('hr_candidates');
        $data['candidates'] = $this->candidate_model->get_candidates_with_staff($filters);
        $data['filters'] = $filters;
        $this->load->view('candidates/manage', $data);
    }

    public function view($id)
    {
        $data['candidate'] = $this->candidate_model->get_candidate_profile($id);
        if (!$data['candidate']) {
            show_404();
        }
        
        $this->load->model('hr/contract_model');
        $this->load->model('hr/assignment_model');
        $this->load->model('hr/certification_model');
        
        $data['title'] = _l('hr_candidate_profile');
        $data['contracts'] = $this->contract_model->all(['c.candidate_id' => $id]);
        $data['assignments'] = $this->assignment_model->get_by_candidate($id);
        $data['certifications'] = $this->certification_model->get_by_candidate($id);
        
        $this->load->view('candidates/profile', $data);
    }

    public function create()
    {
        $this->load->model('hr/Department_model');
        $this->load->model('hr/Designation_model');

        if ($this->input->post()) {
            $post = $this->input->post(null, true);

            $email_checked = $this->candidate_model->all(['email' => trim($post['email'])]);
            if($email_checked){
                set_alert('warning', _l($post['email'].' email already exists'));
                redirect(admin_url('hr/candidate/create'));
            }


            $candidateData = [
                'first_name' => trim($post['first_name'] ?? ''),
                'last_name' => trim($post['last_name'] ?? ''),
                'email' => trim($post['email'] ?? '') ?: NULL, // <-- store NULL if empty
                'phone' => trim($post['phone'] ?? ''),
                'stream_type' => trim($post['stream_type'] ?? ''),
                'job_role' => trim($post['job_role'] ?? ''),
                'gender' => trim($post['gender'] ?? ''),
                'employee_type' => trim($post['employee_type'] ?? ''),
                'contract_type' => trim($post['contract_type'] ?? ''),
                'template_type' => trim($post['template_type'] ?? ''),
                'department_type' => trim($post['department_type'] ?? ''),
                'designation_type' => trim($post['designation_type'] ?? ''),
                'preferred_job_type' => trim($post['preferred_job_type'] ?? ''),
                'rate_currency' => trim($post['rate_currency'] ?? ''),
                'rate' => trim($post['rate'] ?? 0),
                'rate_type' => trim($post['rate_type'] ?? ''),
                'experience_month' => trim($post['experience_month'] ?? 0),
                'experience_years' => trim($post['experience_years'] ?? 0),
                'created_by' => get_staff_user_id(),
                'education' => trim($post['education'] ?? ''),
                'notes' => trim($post['notes'] ?? ''),
                'status' => $post['status'] ?? 'applied',
            ];

            if($_FILES['resume']['name']) {
                $uploadPath = FCPATH . 'uploads/hr/candidate/resume/'; // Full path to /uploads directory
                // Ensure the upload folder exists
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }
                // Handle file upload
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'pdf|doc|docx|txt';
                $config['max_size'] = 2048; // 2MB
                $config['file_name'] = 'resume_' . $staff_id . '_' . time() . '_' . $_FILES['resume']['name'];

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('resume')) {
                    $uploadData = $this->upload->data();
                    $candidateData['resume'] = $uploadData['file_name'];
                } else {
                    set_alert('warning', _l('hr_resume_upload_failed') . ': ' . $this->upload->display_errors());
                    $candidateData['resume'] = '';
                }
            } else {
                $candidateData['resume'] = '';
            }
            

            $id = $this->candidate_model->add($candidateData);
            if ($id) {
                set_alert('success', _l('added_successfully', _l('hr_candidate')));
            }
            redirect(admin_url('hr/candidate/information/'.$id));
        }

        $data['departments'] = $this->Department_model->get_all();
        $data['designations'] = $this->Designation_model->get_all();
        

        $data['title'] = _l('hr_new_candidate');
        $this->load->view('candidates/add_edit', $data);
    }

    public function edit($id)
    {
        $this->load->model('hr/Department_model');
        $this->load->model('hr/Designation_model');

        if ($this->input->post()) {

            $candidate = $this->candidate_model->get($id);
            $staff_id = $candidate->staff_id;
            $post = $this->input->post(null, true);
            $candidateData = [
                'candidate_type' => $post['candidate_type'] ?? 'permanent',
                'first_name' => trim($post['first_name'] ?? ''),
                'last_name' => trim($post['last_name'] ?? ''),
                'email' => trim($post['email'] ?? ''),
                'phone' => trim($post['phone'] ?? ''),
                'position_applied' => trim($post['position_applied'] ?? ''),
                'resume' => trim($post['resume'] ?? ''),
                'skills' => trim($post['skills'] ?? ''),
                'experience_years' => (int)($post['experience_years'] ?? 0),
                'education' => trim($post['education'] ?? ''),
                'department_type' => trim($post['department_type'] ?? ''),
                'designation_type' => trim($post['designation_type'] ?? ''),
                'status' => $post['status'] ?? 'applied',
                'source' => trim($post['source'] ?? ''),
                'notes' => trim($post['notes'] ?? ''),
            ];

            if($_FILES['resume']['name']) {
                $uploadPath = FCPATH . 'uploads/hr/candidate/resume/'; // Full path to /uploads directory
                log_message('error', 'Upload Path: ' . $uploadPath);
                // Ensure the upload folder exists
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }
                // Handle file upload
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'pdf|doc|docx|txt';
                $config['max_size'] = 2048; // 2MB
                $config['file_name'] = 'resume_' . $staff_id . '_' . time() . '_' . $_FILES['resume']['name'];

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('resume')) {
                    $uploadData = $this->upload->data();
                    $candidateData['resume'] = $uploadData['file_name'];
                } else {
                    set_alert('warning', _l('hr_resume_upload_failed') . ': ' . $this->upload->display_errors());
                    $candidateData['resume'] = '';
                }
            } else {
                $candidateData['resume'] = '';
            }

            $success = $this->candidate_model->update($id, $candidateData);
            if ($success) {
                set_alert('success', _l('updated_successfully', _l('hr_candidate')));
            }
            redirect(admin_url('hr/candidate'));
        }

        $data['candidate'] = $this->candidate_model->get($id);
        if (!$data['candidate']) {
            show_404();
        }

        $data['departments'] = $this->Department_model->get_all();
        $data['designations'] = $this->Designation_model->get_all();

        $data['title'] = _l('hr_edit_candidate');
        $this->load->view('candidates/add_edit', $data);
    }

    public function delete($id)
    {
        $this->candidate_model->delete($id);
        set_alert('success', _l('deleted', _l('hr_candidate')));
        redirect(admin_url('hr/candidate'));
    }

    public function enable_login($id)
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $staff_id = $post['staff_id'];
            
            if ($staff_id) {
                $success = $this->candidate_model->enable_login($id, $staff_id);
                if ($success) {
                    set_alert('success', _l('hr_candidate_login_enabled'));
                }
            }
            redirect(admin_url('hr/candidate/view/' . $id));
        }

        $data['candidate'] = $this->candidate_model->get($id);
        if (!$data['candidate']) {
            show_404();
        }

        // Get available staff members
        $this->load->model('staff_model');
        $data['staff'] = $this->staff_model->get('', ['active' => 1]);
        $data['title'] = _l('hr_enable_candidate_login');
        $this->load->view('candidates/enable_login', $data);
    }

    public function disable_login($id)
    {
        $success = $this->candidate_model->disable_login($id);
        if ($success) {
            set_alert('success', _l('hr_candidate_login_disabled'));
        }
        redirect(admin_url('hr/candidate/view/' . $id));
    }



// public function information($id)
// {
//     $this->load->helper('hr_email');
//     $candidate = $this->candidate_model->get($id);
//     if (!$candidate) show_404();

//     $data['candidate'] = $candidate;
//     $data['contract_template'] = $this->contract_template_model->all();
//     $data['title'] = _l('Candidate Information');

//     if ($this->input->post()) {
//         $post = $this->input->post(null, true);

//         // Prepare candidate data
//         $candidateData = [
//             'contract_type'      => trim($post['contract_type'] ?? ''),
//             'contract_template'  => !empty($post['contract_template']) ? implode(',', (array)$post['contract_template']) : '',
//             'template_type'      => trim($post['template_type'] ?? ''),
//             'preferred_job_type' => trim($post['preferred_job_type'] ?? ''),
//             'rate_currency'      => trim($post['rate_currency'] ?? ''),
//             'rate'               => trim($post['rate'] ?? 0),
//             'rate_type'          => trim($post['rate_type'] ?? ''),
//             'experience_month'   => trim($post['experience_month'] ?? 0),
//             'experience_years'   => trim($post['experience_years'] ?? 0),
//             'valid_date'         => trim($post['valid_date'] ?? ''),
//             'address'            => trim($post['address'] ?? ''),
//             'date_of_birth'      => trim($post['date_of_birth'] ?? ''),
//         ];

//         // Resume upload
//         if (!empty($_FILES['resume']['name'])) {
//             $uploadPath = FCPATH . 'uploads/hr/candidate/resume/';
//             if (!is_dir($uploadPath)) mkdir($uploadPath, 0755, true);

//             $config = [
//                 'upload_path'   => $uploadPath,
//                 'allowed_types' => 'pdf|doc|docx|txt',
//                 'max_size'      => 2048,
//                 'file_name'     => 'resume_' . get_staff_user_id() . '_' . time() . '_' . $_FILES['resume']['name']
//             ];

//             $this->load->library('upload', $config);

//             if ($this->upload->do_upload('resume')) {
//                 $uploadData = $this->upload->data();
//                 $candidateData['resume'] = $uploadData['file_name'];
//             } else {
//                 set_alert('warning', _l('hr_resume_upload_failed') . ': ' . $this->upload->display_errors());
//                 $candidateData['resume'] = '';
//             }
//         }

//         // Email token
//         $candidateData['email_token'] = bin2hex(random_bytes(16));

//         $success = $this->candidate_model->update($id, $candidateData);
//         $candidate = $this->candidate_model->get($id);

//         // Send verification email
//         $verificationLink = site_url('hr/candidate_client/index/'.$candidateData['email_token']);
//         $to = $candidate->email;
//         $subject = "Verify Your Email - Candidate Portal";
//         $body = "<p>Hello {$candidate->first_name} {$candidate->last_name},</p>
//                  <p>Please verify your email by clicking below link:</p>
//                  <a href='{$verificationLink}'>Verify Email</a>";

//         hr_send_email($to, $subject, $body);

//         if ($success) set_alert('success', _l('updated_successfully', _l('hr_candidate')));
//         else set_alert('warning', _l('hr_candidate_update_failed'));

//         // Multi-tab URLs
//         $contractTemplates = !empty($candidate->contract_template) ? explode(',', $candidate->contract_template) : [];
//         $redirect_urls = [];
//         foreach ($contractTemplates as $template_id) {
//             $redirect_urls[] = admin_url('hr/candidate/sign_contract/'.$candidate->id.'?template_id='.$template_id);
//         }
//         $data['redirect_urls'] = $redirect_urls;

//         $this->load->view('candidates/information', $data);
//         return;
//     }

//     // GET request
//     $data['redirect_urls'] = [];
//     $this->load->view('candidates/information', $data);
// }

// public function information($id)
// {
//     $this->load->helper('hr_email');
//     $candidate = $this->candidate_model->get($id);
//     if (!$candidate) show_404();

//     $data['candidate'] = $candidate;
//     $data['contract_template'] = $this->contract_template_model->all();

//     $data['template_type'] = $this->db
//         ->select('id, title')
//         ->from('tblhr_contracts')
//         ->get()
//         ->result_array();


//     $data['title'] = _l('Candidate Information');

//     if ($this->input->post()) {
//         $post = $this->input->post(null, true);

//         $candidateData = [
//             'contract_type'      => trim($post['contract_type'] ?? ''),
//             // 'contract_template'  => !empty($post['contract_template']) ? implode(',', (array)$post['contract_template']) : '',
//             'template_type'      => !empty($post['template_type']) ? implode(',', (array)$post['template_type']) : '',
//             'preferred_job_type' => trim($post['preferred_job_type'] ?? ''),
//             'rate_currency'      => trim($post['rate_currency'] ?? ''),
//             'rate'               => trim($post['rate'] ?? 0),
//             'rate_type'          => trim($post['rate_type'] ?? ''),
//             'experience_month'   => trim($post['experience_month'] ?? 0),
//             'experience_years'   => trim($post['experience_years'] ?? 0),
//             'valid_date'         => trim($post['valid_date'] ?? ''),
//             'address'            => trim($post['address'] ?? ''),
//             'date_of_birth'      => trim($post['date_of_birth'] ?? ''),
//         ];

//         // Resume upload
//         if (!empty($_FILES['resume']['name'])) {
//             $uploadPath = FCPATH . 'uploads/hr/candidate/resume/';
//             if (!is_dir($uploadPath)) mkdir($uploadPath, 0755, true);

//             $config = [
//                 'upload_path'   => $uploadPath,
//                 'allowed_types' => 'pdf|doc|docx|txt',
//                 'max_size'      => 2048,
//                 'file_name'     => 'resume_' . get_staff_user_id() . '_' . time() . '_' . $_FILES['resume']['name']
//             ];

//             $this->load->library('upload', $config);

//             if ($this->upload->do_upload('resume')) {
//                 $uploadData = $this->upload->data();
//                 $candidateData['resume'] = $uploadData['file_name'];
//             } else {
//                 set_alert('warning', _l('hr_resume_upload_failed') . ': ' . $this->upload->display_errors());
//                 $candidateData['resume'] = '';
//             }
//         }

//         // Email token
//         $candidateData['email_token'] = bin2hex(random_bytes(16));

//         $success = $this->candidate_model->update($id, $candidateData);
//         $candidate = $this->candidate_model->get($id);

//         // Send verification email
//         $verificationLink = site_url('hr/candidate_client/index/'.$candidateData['email_token']);
//         $to = $candidate->email;
//         $subject = "Verify Your Email - Candidate Portal";
//         $body = "<p>Hello {$candidate->first_name} {$candidate->last_name},</p>
//                  <p>Please verify your email by clicking below link:</p>
//                  <a href='{$verificationLink}'>Verify Email</a>";

//         hr_send_email($to, $subject, $body);

//         if ($success) set_alert('success', _l('updated_successfully', _l('hr_candidate')));
//         else set_alert('warning', _l('hr_candidate_update_failed'));

//         // Multi-tab URLs
//         // $contractTemplates = !empty($candidate->contract_template) ? explode(',', $candidate->contract_template) : [];
//         // $redirect_urls = [];
//         // foreach ($contractTemplates as $template_id) {
//         //     $redirect_urls[] = admin_url('hr/candidate/sign_contract/'.$candidate->id.'?template_id='.$template_id);
//         // }
//         // $data['redirect_urls'] = $redirect_urls;

//         // reload view
//         $this->load->view('candidates/information', $data);
//         return;
//     }

//     // GET request
//     $data['redirect_urls'] = [];
//     $this->load->view('candidates/information', $data);
// }

    public function information($id)
    {
        $this->load->helper('hr_email');
        $candidate = $this->candidate_model->get($id);
        if (!$candidate) show_404();

        $data['candidate'] = $candidate;
        $data['contract_template'] = $this->contract_template_model->all();
        $certificate_type = $this->certificate_template_model->get();
        $certificate_type_array = array_map(function($obj) {
            return (array) $obj;
        }, $certificate_type);

        $data['certificate_type'] = $certificate_type_array;

        $data['template_type'] = $this->db
            ->select('id, title')
            ->from('tblhr_contracts')
            ->get()
            ->result_array();

        $data['title'] = _l('Candidate Information');

        if ($this->input->post()) {
            $post = $this->input->post(null, true);

            $candidateData = [
                'contract_type'      => trim($post['contract_type'] ?? ''),
                'template_type'      => !empty($post['template_type']) ? implode(',', (array)$post['template_type']) : '',
                'certificate_type'      => !empty($post['certificate_type']) ? implode(',', (array)$post['certificate_type']) : '',
                'preferred_job_type' => trim($post['preferred_job_type'] ?? ''),
                'rate_currency'      => trim($post['rate_currency'] ?? ''),
                'rate'               => trim($post['rate'] ?? 0),
                'rate_type'          => trim($post['rate_type'] ?? ''),
                'experience_month'   => trim($post['experience_month'] ?? 0),
                'experience_years'   => trim($post['experience_years'] ?? 0),
                'valid_date'         => trim($post['valid_date'] ?? ''),
                'address'            => trim($post['address'] ?? ''),
                'date_of_birth'      => trim($post['date_of_birth'] ?? ''),
            ];

            // Resume upload
            if (!empty($_FILES['resume']['name'])) {
                $uploadPath = FCPATH . 'uploads/hr/candidate/resume/';
                if (!is_dir($uploadPath)) mkdir($uploadPath, 0755, true);

                $config = [
                    'upload_path'   => $uploadPath,
                    'allowed_types' => 'pdf|doc|docx|txt',
                    'max_size'      => 2048,
                    'file_name'     => 'resume_' . get_staff_user_id() . '_' . time() . '_' . $_FILES['resume']['name']
                ];

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('resume')) {
                    $uploadData = $this->upload->data();
                    $candidateData['resume'] = $uploadData['file_name'];
                } else {
                    set_alert('warning', _l('hr_resume_upload_failed') . ': ' . $this->upload->display_errors());
                    $candidateData['resume'] = '';
                }
            }

            // Email token
            $candidateData['email_token'] = bin2hex(random_bytes(16));

            $success = $this->candidate_model->update($id, $candidateData);

            // ✅ Insert certificate records
            if (!empty($post['certificate_type'])) {
                $certificateIds = (array)$post['certificate_type'];
                $this->db->where('candidate_id', $id)->delete('tblhr_certifications');
                foreach ($certificateIds as $cert_id) {
                    $this->db->insert('tblhr_certifications', [
                        'candidate_id'     => $id,
                        'certificate_type' => $cert_id,
                        'created_at'       => date('Y-m-d H:i:s'),
                    ]);
                }
            }

            // Store each selected contract as a draft in tblhr_candidate_contracts
            if (!empty($post['template_type'])) {
                $templateIds = (array)$post['template_type'];
                foreach ($templateIds as $template_id) {
                    $exists = $this->db->where([
                        'candidate_id' => $id,
                        'contract_id'  => $template_id
                    ])->get('tblhr_candidate_contracts')->row();

                    if (!$exists) {
                        $this->db->insert('tblhr_candidate_contracts', [
                            'candidate_id' => $id,
                            'contract_id'  => $template_id,
                            'date'         => date('Y-m-d'),
                            'status'       => 'draft'
                        ]);
                    }
                }
            }

            $candidate = $this->candidate_model->get($id);

            // Send verification email
            $verificationLink = site_url('hr/candidate_client/index/'.$candidateData['email_token']);
            $to = $candidate->email;
            $subject = "Verify Your Email - Candidate Portal";
            $body = "<p>Hello {$candidate->first_name} {$candidate->last_name},</p>
                    <p>Please verify your email by clicking below link:</p>
                    <a href='{$verificationLink}'>Verify Email</a>";

            hr_send_email($to, $subject, $body);

            if ($success) set_alert('success', _l('updated_successfully', _l('hr_candidate')));
            else set_alert('warning', _l('hr_candidate_update_failed'));

            $this->load->view('candidates/information', $data);
            return;
        }

        $data['redirect_urls'] = [];
        $this->load->view('candidates/information', $data);
    }




    // public function view_contract_pdf($contract_id)
    // {
    //     $this->load->model('candidate_client_model');
        
    //     // Get contract details with template images
    //     $this->db->select('cc.*, c.title, c.details, c.cover_image, c.background_image, c.last_image, c.fields_list, ca.first_name, ca.last_name, ca.email, ca.phone, ca.address, cc.company_info');
    //     $this->db->from(db_prefix() . 'hr_candidate_contracts as cc');
    //     $this->db->join(db_prefix() . 'hr_contracts as c', 'c.id = cc.contract_id', 'inner');
    //     $this->db->join(db_prefix() . 'hr_candidates as ca', 'ca.id = cc.candidate_id', 'inner');
    //     $this->db->where('cc.id', $contract_id);
    //     $contract = $this->db->get()->row();

    //     if (!$contract) {
    //         show_error('Contract not found');
    //     }

    //     // Load Perfex TCPDF helper
    //     $this->load->helper('pdf');

    //     // Load Perfex CRM's built-in TCPDF library
    //     $this->load->library('pdf');

    //     // Create new PDF instance
    //     $pdf = new Pdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

    //     $pdf->SetTitle('Contract - ' . $contract->id);
    //     $pdf->SetAuthor(get_option('companyname'));
    //     $pdf->SetMargins(15, 20, 15);
        
    //     // Add first page with cover image
    //     $pdf->AddPage();
        
    //     // Add cover image if exists
    //     if (!empty($contract->first_page) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->first_page)) {
    //         $cover_image_path = FCPATH . 'uploads/hr/contract_template/' . $contract->first_page;
    //         $pdf->Image($cover_image_path, 0, 0, 210, 297, '', '', '', true, 300, '', false, false, 0, false, false, false);
    //     }
        
    //     // Add second page for contract content
    //     $pdf->AddPage();
        
    //     // Add background image for content pages if exists
    //     if (!empty($contract->background_page) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->background_page)) {
    //         $background_image_path = FCPATH . 'uploads/hr/contract_template/' . $contract->background_page;
    //         $pdf->Image($background_image_path, 0, 0, 210, 297, '', '', '', true, 300, '', false, false, 0, false, false, false);
    //     }

    //     // Build HTML
    //     $html = '<h2 align="center">'.$contract->title.'</h2>';
    //     $html .= '<p><strong>Created At:</strong> ' . _dt($contract->created_at) . '</p>';
    //     $html .= '<hr width="100%" />';
    //     $html .= '<div>' . $contract->details . '</div>';
    //     $html .= '<br /><br />';

    //     $html .= '<table border="0" cellpadding="5" cellspacing="0" width="100%">
    //         <tr>
    //             <td width="50%" valign="top">
    //                 <strong>INTERN</strong><br><br>
    //                 <table cellpadding="3" cellspacing="0" border="0">
    //                     <tr>
    //                         <td>Name:</td>
    //                         <td>________________</td>
    //                     </tr>
    //                     <tr>
    //                         <td>Job Role:</td>
    //                         <td>________________</td>
    //                     </tr>
    //                     <tr>
    //                         <td>Signature:</td>
    //                         <td>________________</td>
    //                     </tr>
    //                     <tr>
    //                         <td>Date:</td>
    //                         <td>________________</td>
    //                     </tr>
    //                 </table>
    //             </td>

    //             <td width="50%" valign="top">
    //                 <strong>COMPANY DETAILS</strong><br><br>
    //             </td>
    //         </tr>
    //     </table>
    //     <br /><hr width="100%" />';
    //     $pdf->writeHTML($html, true, false, true, false, '');
        
    //     // Add last page with last page image if exists
    //     if (!empty($contract->last_page) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->last_page)) {
    //         $pdf->AddPage();
    //         $last_page_image_path = FCPATH . 'uploads/hr/contract_template/' . $contract->last_page;
    //         $pdf->Image($last_page_image_path, 0, 0, 210, 297, '', '', '', true, 300, '', false, false, 0, false, false, false);
    //     }

    //     // Stream inline (I = inline, no saving)
    //     $pdf->Output(slug_it($contract->title) . '.pdf', 'I');
    // }

    // public function sign_contract($candidate_id)
    // {
    //     // Load models
    //     $this->load->model('candidate_client_model');
    //     $this->load->model('Candidate_contract_model', 'contract');
    //     $this->load->model('candidate_model');

    //     if ($this->input->post()) {
    //         $post = $this->input->post(null, true);
    //         // dd($post);
    //         $candidate = $this->candidate_model->get($candidate_id);
    //         $contract = $this->contract_template_model->get($candidate->contract_template);
    //         $fields_list = json_decode($contract->fields_list ?? '[]', true);
    //         $intern_info = [];

    //         foreach ($fields_list as $field) {
    //             $name = $field['name'] ?? strtolower(str_replace(' ', '_', $field['label'] ?? ''));
    //             if ($name) {
    //                 $intern_info[$name] = $post[$name] ?? '';
    //             }
    //         }

    //         $insertData = [
    //             'candidate_id' => $candidate_id,
    //             'contract_id'  => $candidate->contract_template,
    //             'intern_info'  => json_encode($intern_info),
    //             'company_info' => $post['company_info'] ?? '',
    //         ];

    //         $this->contract->insert($insertData);
    //         set_alert('success', 'Contract signed successfully');
    //         redirect('admin/hr/candidate');
    //     }

    //     // Get candidate row
    //     $candidate = $this->db->where('id', $candidate_id)
    //                         ->get('tblhr_candidates')
    //                         ->row();

    //     if (!$candidate) {
    //         set_alert('danger', 'Candidate not found');
    //         redirect(site_url('hr/candidate/information/'.$candidate_id));
    //     }

    //     // Fetch the contract template linked to candidate
    //     $contract = $this->db->where('id', $candidate->contract_template)
    //                         ->get('tblhr_contracts')
    //                         ->row();

    //     if (!$contract) {
    //         set_alert('danger', 'Contract template not found');
    //         redirect(site_url('hr/candidate/information/'.$candidate_id));
    //     }

    //     // Prepare data for the view
    //     $data = [
    //         'title'       => _l('Sign Contract'),
    //         'candidate'   => $candidate,
    //         'contract'    => $contract,
    //         'pdf_url'     => site_url('hr/candidate/view_contract_pdf/' . $contract->id),
    //         'fields_list' => json_decode($contract->fields_list ?? '[]', true)
    //     ];

    //     $this->load->view('candidates/sign_contract', $data);
    // }


    public function view_contract_pdf($template_id)
{
    // Fetch contract template
    $contract = $this->db->where('id', $template_id)
                         ->get(db_prefix() . 'hr_contracts')
                         ->row();

    if (!$contract) {
        show_error('Contract template not found');
    }

    // Load Perfex TCPDF helper
    $this->load->helper('pdf');
    $this->load->library('pdf');

    $pdf = new Pdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('Contract - ' . $contract->title);
    $pdf->SetAuthor(get_option('companyname'));
    $pdf->SetMargins(15, 20, 15);

    // Cover page
    $pdf->AddPage();
    if (!empty($contract->cover_image) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->cover_image)) {
        $pdf->Image(FCPATH . 'uploads/hr/contract_template/' . $contract->cover_image, 0, 0, 210, 297, '', '', '', true, 300, '', false, false, 0, false, false, false);
    }

    // Content page
    $pdf->AddPage();
    if (!empty($contract->background_image) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->background_image)) {
        $pdf->Image(FCPATH . 'uploads/hr/contract_template/' . $contract->background_image, 0, 0, 210, 297, '', '', '', true, 300, '', false, false, 0, false, false, false);
    }

    $html = '<h2 align="center">'.$contract->title.'</h2>';
    $html .= '<p><strong>Created At:</strong> ' . _dt($contract->created_at) . '</p>';
    $html .= '<hr width="100%" />';
    $html .= '<div>' . $contract->details . '</div><br /><br />';

    $html .= '<table border="0" cellpadding="5" cellspacing="0" width="100%">
        <tr>
            <td width="50%" valign="top">
                <strong>INTERN</strong><br><br>
                <table cellpadding="3" cellspacing="0" border="0">
                    <tr><td>Name:</td><td>________________</td></tr>
                    <tr><td>Job Role:</td><td>________________</td></tr>
                    <tr><td>Signature:</td><td>________________</td></tr>
                    <tr><td>Date:</td><td>________________</td></tr>
                </table>
            </td>
            <td width="50%" valign="top">
                <strong>COMPANY DETAILS</strong><br><br>
            </td>
        </tr>
    </table><br /><hr width="100%" />';

    $pdf->writeHTML($html, true, false, true, false, '');

    // Last page
    if (!empty($contract->last_image) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->last_image)) {
        $pdf->AddPage();
        $pdf->Image(FCPATH . 'uploads/hr/contract_template/' . $contract->last_image, 0, 0, 210, 297, '', '', '', true, 300, '', false, false, 0, false, false, false);
    }

    // Output PDF inline
    $pdf->Output(slug_it($contract->title) . '.pdf', 'I');
}


    public function sign_contract($candidate_id)
    {
        $candidate = $this->candidate_model->get($candidate_id);
        if (!$candidate) {
            set_alert('danger', 'Candidate not found');
            redirect(admin_url('hr/candidate/information/'.$candidate_id));
        }

        $template_id = (int)$this->input->get('template_id');
        if (!$template_id) {
            set_alert('danger', 'Template ID missing');
            redirect(admin_url('hr/candidate/information/'.$candidate_id));
        }

        // Load the contract
        $contract = $this->db->where('id', $template_id)->get('tblhr_contracts')->row();
            // var_dump($contract); die;
        if (!$contract) {
            set_alert('danger', 'Contract template not found');
            redirect(admin_url('hr/candidate/information/'.$candidate_id));
        }

        // POST: save contract
        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $fields_list = json_decode($contract->fields_list ?? '[]', true);
            $intern_info = [];

            foreach ($fields_list as $field) {
                $name = $field['name'] ?? strtolower(str_replace(' ', '_', $field['label'] ?? ''));
                if ($name) $intern_info[$name] = $post[$name] ?? '';
            }

            $this->load->model('Candidate_contract_model', 'contract');
            $this->contract->insert([
                'candidate_id' => $candidate_id,
                'contract_id'  => $template_id,
                'intern_info'  => json_encode($intern_info),
                'company_info' => $post['company_info'] ?? ''
            ]);

            set_alert('success', 'Contract signed successfully');
            redirect(admin_url('hr/candidate'));
        }

        // Prepare view data
        $data = [
            'title'       => _l('Sign Contract'),
            'candidate'   => $candidate,
            'contract'    => $contract,
            'pdf_url'     => site_url('hr/candidate/view_contract_pdf/' . $contract->id),
            'fields_list' => json_decode($contract->fields_list ?? '[]', true)
        ];

        $this->load->view('candidates/sign_contract', $data);
    }



    
    public function get($id) {
        return $this->db->where('id', $id)->get('tblhr_candidates')->row();
    }
}