<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Certificate_template extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('hr/Certificate_template_model', 'certificate_template_model');
    }

    public function index()
    {
        $data['title'] = _l('Certificate Templates');
        $data['certifications'] = $this->certificate_template_model->get();
        
        $this->load->view('hr/certifications/manage', $data);
    }

    // public function create($id = '')
    // {
    //     $data = [];
    //     if ($this->input->post()) {
    //         $post = $this->input->post();
    //         $uploaded_image = '';

    //         // Handle file upload
    //         if (!empty($_FILES['background_image']['name'])) {
    //             $uploaded_image = $this->_upload_image();
    //         }

    //         $certificateData = [
    //             'title' => $post['title'],
    //             'details' => $post['details'],
    //             'background_image' => $uploaded_image
    //         ];

    //         if ($id == '') {
    //             $insert_id = $this->certificate_template_model->add($certificateData);
    //             if ($insert_id) {
    //                 set_alert('success', _l('added_successfully', _l('certificate_template')));
    //             }
    //         } else {
    //             if ($uploaded_image == '') {
    //                 unset($certificateData['background_image']);
    //             }
    //             $success = $this->certificate_template_model->update($id, $certificateData);
    //             if ($success) {
    //                 set_alert('success', _l('updated_successfully', _l('certificate_template')));
    //             }
    //         }

    //         redirect(admin_url('hr/certifications'));
    //     }

    //     if ($id) {
    //         $data['certificate_template'] = $this->certificate_template_model->get($id);
    //         $data['title'] = _l('Edit Certificate Template');
    //     } else {
    //         $data['title'] = _l('Add Certificate Template');
    //     }

    //     $this->load->view('hr/certificate_templates/add_edit', $data);
    // }

    public function create($id = '')
{
    $data = [];

    if ($this->input->post()) {
        $post = $this->input->post();
        $uploaded_image = '';

        if (!empty($_FILES['background_image']['name'])) {
            $uploaded_image = $this->_upload_image();
        }

        $certificateData = [
            'title'   => $post['title'],
            'details' => $post['details'],
        ];

        if ($uploaded_image != '') {
            $certificateData['background_image'] = $uploaded_image;
        }

        if ($id == '') {
            $insert_id = $this->certificate_template_model->add($certificateData);
            if ($insert_id) {
                set_alert('success', _l('added_successfully', _l('Certificate Template')));
            }
        } else {
            $success = $this->certificate_template_model->update($id, $certificateData);
            if ($success) {
                set_alert('success', _l('updated_successfully', _l('Certificate Template')));
            }
        }

        redirect(admin_url('hr/certificate_template'));
    }

    if ($id) {
        $certificate_template = $this->certificate_template_model->get($id);
        if ($certificate_template) {
            $data['certificate_template'] = $certificate_template;
            $data['title'] = _l('Edit Certificate Template');
        } else {
            set_alert('warning', _l('Record not found'));
            redirect(admin_url('hr/certificate_template'));
        }
    } else {
        $data['title'] = _l('Add Certificate Template');
    }

    $this->load->view('hr/certifications/add_edit', $data);
}



    public function delete($id)
    {
        if (!$id) redirect(admin_url('hr/certificate_template'));

        $success = $this->certificate_template_model->delete($id);
        if ($success) {
            set_alert('success', _l('deleted', _l('Certificate Templates')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('Certificate Templates')));
        }
        redirect(admin_url('hr/certificate_template'));
    }

    private function _upload_image()
    {
        $path = FCPATH . 'uploads/hr/certificates/';
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }

        $config['upload_path'] = $path;
        $config['allowed_types'] = '*';
        $config['max_size'] = 2048;
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        if ($this->upload->do_upload('background_image')) {
            $fileData = $this->upload->data();
            return 'uploads/hr/certificates/' . $fileData['file_name'];
        } else {
            set_alert('warning', $this->upload->display_errors());
            return '';
        }
    }
}
