<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Certification extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        if (!is_admin()) {
            access_denied('hr');
        }
        $this->load->model('hr/certification_model');
        $this->load->model('hr/candidate_model');
    }

    public function index()
    {
        $data['title'] = _l('hr_certifications');
        $data['certifications'] = $this->certification_model->all();
        $this->load->view('certifications/manage', $data);
    }

    public function create()
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);

            $certificationData = [
                'candidate_id' => (int)($post['candidate_id'] ?? 0),
                'certificate_type' => trim($post['certificate_type'] ?? ''),
                'certificate_number' => trim($post['certificate_number'] ?? ''),
                'issued_at' => trim($post['issued_at'] ?? null),
                'expires_at' => trim($post['expires_at'] ?? null),
                'file_path' => trim($post['file_path'] ?? ''),
                'status' => trim($post['status'] ?? 'draft'),
            ];

            if($_FILES['file_path']['name']) {
                $uploadPath = FCPATH . 'uploads/hr/candidate/certificate/'; // Full path to /uploads directory
                // Ensure the upload folder exists
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }
                // Handle file upload
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'pdf|doc|docx|txt';
                $config['max_size'] = 2048; // 2MB
                $config['file_name'] = 'certificate_' . time() . '_' . $_FILES['file_path']['name'];

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('file_path')) {
                    $uploadData = $this->upload->data();
                    $certificationData['file_path'] = $uploadData['file_name'];
                } else {
                    set_alert('warning', _l('hr_certificate_upload_failed') . ': ' . $this->upload->display_errors());
                    $certificationData['file_path'] = '';
                }
            } else {
                $certificationData['file_path'] = '';
            }

            $id = $this->certification_model->add($certificationData);
            if ($id) {
                set_alert('success', _l('added_successfully', _l('hr_certification')));
            }
            redirect(admin_url('hr/certification'));
        }

        $data['title'] = _l('hr_new_certification');
        $data['candidates'] = $this->candidate_model->all();
        $this->load->view('certifications/add_edit', $data);
    }

    public function edit($id)
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $certificationData = [
                'candidate_id' => (int)($post['candidate_id'] ?? 0),
                'certificate_type' => trim($post['certificate_type'] ?? ''),
                'certificate_number' => trim($post['certificate_number'] ?? ''),
                'issued_at' => trim($post['issued_at'] ?? null),
                'expires_at' => trim($post['expires_at'] ?? null),
                'status' => trim($post['status'] ?? 'draft'),
            ];

            if($_FILES['file_path']['name']) {
                $uploadPath = FCPATH . 'uploads/hr/candidate/certificate/'; // Full path to /uploads directory
                // Ensure the upload folder exists
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }
                // Handle file upload
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'pdf|doc|docx|txt';
                $config['max_size'] = 2048; // 2MB
                $config['file_name'] = 'certificate_' . time() . '_' . $_FILES['file_path']['name'];

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('file_path')) {
                    $uploadData = $this->upload->data();
                    $certificationData['file_path'] = $uploadData['file_name'];
                } else {
                    set_alert('warning', _l('hr_certificate_upload_failed') . ': ' . $this->upload->display_errors());
                    $certificationData['file_path'] = '';
                }
            }

            $success = $this->certification_model->update($id, $certificationData);
            if ($success) {
                set_alert('success', _l('updated_successfully', _l('hr_certification')));
            }
            redirect(admin_url('hr/certification'));
        }

        $data['certification'] = $this->certification_model->get($id);
        if (!$data['certification']) {
            show_404();
        }
        $data['title'] = _l('hr_edit_certification');
        $data['candidates'] = $this->candidate_model->all();
        $this->load->view('certifications/add_edit', $data);
    }

    public function delete($id)
    {
        $this->certification_model->delete($id);
        set_alert('success', _l('deleted', _l('hr_certification')));
        redirect(admin_url('hr/certification'));
    }

    public function generate($candidate_id)
    {
        $candidate = $this->candidate_model->get($candidate_id);
        if (!$candidate) {
            show_404();
        }

        $certificate_type = $this->input->post('certificate_type') ?? 'Completion Certificate';
        $id = $this->certification_model->generate_certificate($candidate_id, $certificate_type);
        
        if ($id) {
            set_alert('success', _l('hr_certificate_generated'));
        }
        redirect(admin_url('hr/candidate/view/' . $candidate_id));
    }

    public function validate()
    {
        $certificate_number = $this->input->get('certificate_number');
        $certificate = $this->certification_model->validate_certificate($certificate_number);
        
        $data['title'] = _l('hr_validate_certificate');
        $data['certificate'] = $certificate;
        $data['certificate_number'] = $certificate_number;
        $this->load->view('certifications/validate', $data);
    }

    public function download($id)
    {
        $certification = $this->certification_model->get($id);
        if ($certification && $certification->file_path) {
            $file_path = FCPATH . $certification->file_path;
            if (file_exists($file_path)) {
                force_download($file_path, null);
            } else {
                set_alert('danger', _l('file_not_found'));
            }
        } else {
            set_alert('danger', _l('certification_not_found'));
        }
        redirect(admin_url('hr/certification'));
    }
}
