<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Send Email Helper for HR Module
 *
 * @param string $to Recipient email
 * @param string $subject Email subject
 * @param string $body HTML/text message
 * @param string|array|null $attachments File path(s) to attach
 * @param string|null $from Optional sender email
 *
 * @return bool
 */
if (!function_exists('hr_send_email')) {
    function hr_send_email($to, $subject, $body, $attachments = null, $from = null)
    {
        $CI = &get_instance();

        // Load Email Config
        $CI->load->config('email');
        $CI->email->initialize();

        // Debugging if using PHPMailer
        if (get_option('mail_engine') == 'phpmailer') {
            $CI->email->set_debug_output(function ($err) {
                if (!isset($GLOBALS['debug'])) {
                    $GLOBALS['debug'] = '';
                }
                $GLOBALS['debug'] .= $err . '<br />';
                return $err;
            });

            $CI->email->set_smtp_debug(3);
        }

        // Basic settings
        $CI->email->set_newline(config_item('newline'));
        $CI->email->set_crlf(config_item('crlf'));

        // From address
        if (!$from) {
            $from = get_option('smtp_email');
        }
        $CI->email->from($from, get_option('companyname'));

        // To address
        $CI->email->to($to);

        // Subject + Body
        $CI->email->subject($subject);
        $CI->email->message($body);

        // Handle Attachments
        if (!empty($attachments)) {
            if (is_array($attachments)) {
                foreach ($attachments as $file) {
                    if (file_exists($file)) {
                        $CI->email->attach($file);
                    }
                }
            } elseif (file_exists($attachments)) {
                $CI->email->attach($attachments);
            }
        }

        // Send Email
        if ($CI->email->send(true)) {
            return true;
        } else {
            log_message('error', 'Email sending failed: ' . $CI->email->print_debugger());
            return false;
        }
    }
}
