<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Candidate_model extends App_Model
{
    protected $table = '';

    public function __construct()
    {
        parent::__construct();
        $this->table = db_prefix() . 'hr_candidates';
    }

    public function get_by_token($token)
    {
        return $this->db
                    ->select('id,first_name, last_name, email') // only these columns
                    ->get_where('tblhr_candidates', ['email_token' => $token])
                    ->row();
    }



    public function all($where = [])
    {
        if (!empty($where)) {
            $this->db->where($where);
        }
        $this->db->order_by('id', 'DESC');
        return $this->db->get($this->table)->result_array();
    }

    public function get($id)
    {
        $this->db->where('id', $id);
        return $this->db->get($this->table)->row();
    }

    public function add($data)
    {
        $data['created_at'] = date('Y-m-d H:i:s');
        $data['updated_at'] = date('Y-m-d H:i:s');
        $this->db->insert($this->table, $data);
        return (int) $this->db->insert_id();
    }

    public function get_all_candidates($filters = [])
    {
        if (!empty($filters)) {
            if (isset($filters['candidate_type'])) {
                $this->db->where('candidate_type', $filters['candidate_type']);
            }
            if (isset($filters['status'])) {
                $this->db->where('status', $filters['status']);
            }
            if (isset($filters['search'])) {
                $this->db->group_start();
                $this->db->like('first_name', $filters['search']);
                $this->db->or_like('last_name', $filters['search']);
                $this->db->or_like('email', $filters['search']);
                $this->db->group_end();
            }
        }
        $this->db->order_by('id', 'DESC');
        return $this->db->get($this->table)->result_array();
    }

    public function get_candidate_profile($id)
    {
        $this->db->select('c.*, s.firstname as staff_firstname, s.lastname as staff_lastname, s.email as staff_email, s.phonenumber as staff_phone');
        $this->db->from($this->table . ' c');
        $this->db->join(db_prefix() . 'staff s', 'c.staff_id = s.staffid', 'left');
        $this->db->where('c.id', $id);
        return $this->db->get()->row();
    }

    public function get_candidate_by_staff_id($staff_id)
    {
        $this->db->where('staff_id', $staff_id);
        return $this->db->get($this->table)->row();
    }

    public function enable_login($candidate_id, $staff_id)
    {
        $data = [
            'staff_id' => $staff_id,
            'can_login' => 1,
            'login_enabled_at' => date('Y-m-d H:i:s'),
            'status' => 'hired',
            'updated_at' => date('Y-m-d H:i:s')
        ];
        $this->db->where('id', $candidate_id);
        return $this->db->update($this->table, $data);
    }

    public function disable_login($candidate_id)
    {
        $data = [
            'can_login' => 0,
            'login_enabled_at' => null,
            'updated_at' => date('Y-m-d H:i:s')
        ];
        $this->db->where('id', $candidate_id);
        return $this->db->update($this->table, $data);
    }

    public function get_candidates_with_staff($filters = [])
    {
        if (!empty($filters)) {
            if (isset($filters['candidate_type']) && $filters['candidate_type']) {
                $this->db->where('c.candidate_type', $filters['candidate_type']);
            }
            if (isset($filters['status']) && $filters['status']) {
                $this->db->where('c.status', $filters['status']);
            }
            if (isset($filters['search']) && $filters['search']) {
                $this->db->group_start();
                $this->db->like('c.first_name', $filters['search']);
                $this->db->or_like('c.last_name', $filters['search']);
                $this->db->or_like('c.email', $filters['search']);
                $this->db->group_end();
            }
        }

        $this->db->select('c.*, s.firstname as staff_firstname, s.lastname as staff_lastname, s.email as staff_email');
        $this->db->from($this->table . ' c');
        $this->db->join(db_prefix() . 'staff s', 'c.staff_id = s.staffid', 'left');
        $this->db->order_by('c.id', 'DESC');
        return $this->db->get()->result_array();
    }

    public function update($id, $data)
    {
        $data['updated_at'] = date('Y-m-d H:i:s');
        $this->db->where('id', $id);
        return $this->db->update($this->table, $data);
    }

    public function delete($id)
    {
        $this->db->where('id', $id);
        $this->db->delete($this->table);
        return (int) $this->db->affected_rows();
    }
}
