<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Contract_template_model extends App_Model
{
    protected $table = '';

    public function __construct()
    {
        parent::__construct();
        $this->table = db_prefix() . 'hr_contracts';
    }

    public function all($where = [])
{
    if (!empty($where)) {
        $this->db->where($where);
    }

    $this->db->select('c.*, s.firstname, s.lastname');
    $this->db->from($this->table . ' c');
    $this->db->join(db_prefix() . 'staff s', 's.staffid = c.created_by', 'left');
    
    return $this->db->get()->result_array(); // 👈 removed ($this->table)
}

    public function get($id)
    {
        $this->db->where('id', $id);
        return $this->db->get($this->table)->row();
    }

    public function add($data)
    {
        $data['created_at'] = date('Y-m-d H:i:s');
        $data['updated_at'] = date('Y-m-d H:i:s');
        $this->db->insert($this->table, $data);
        return (int) $this->db->insert_id();
    }

    public function update($id, $data)
    {
        $data['updated_at'] = date('Y-m-d H:i:s');
        $this->db->where('id', $id);
        return $this->db->update($this->table, $data);
    }

    public function delete($id)
    {
        $this->db->where('id', $id);
        $this->db->delete($this->table);
        return (int) $this->db->affected_rows();
    }
}
