<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Designation_model extends App_Model
{
    protected $table = 'tblhr_designations';
    protected $primaryKey = 'id';

    public function __construct()
    {
        parent::__construct();
    }

    // Get all designations with department names
    public function get_all()
    {
        return $this->db->get($this->table)->result_array(); // returns objects
    }


    // Get single designation
    public function get($id)
    {
        return $this->db->get_where($this->table, [$this->primaryKey => $id])->row();
    }

    // Insert new designation
    public function insert($data)
{
    if ($this->db->insert($this->table, $data)) {
        return ['status' => true, 'insert_id' => $this->db->insert_id()];
    } else {
        $error = $this->db->error();
        return ['status' => false, 'message' => $error['message']];
    }
}




    // Update designation
    public function update($id, $data)
    {
        return $this->db->where($this->primaryKey, $id)->update($this->table, $data);
    }

    // Delete designation
    public function delete($id)
    {
        return $this->db->delete($this->table, [$this->primaryKey => $id]);
    }
}
