<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Email_template_model extends App_Model
{
    protected $table = '';

    public function __construct()
    {
        parent::__construct();
        $this->table = db_prefix() . 'hr_contract_email_templates';
    }

    public function get_templates()
    {
        return $this->db->get($this->table)->result_array();
    }

    public function get($id)
    {
        return $this->db->where('id', $id)->get($this->table)->row();
    }

    public function update($id, $data)
    {
        $updateData = [
            'subject' => $data['subject'],
            'body'    => $data['body'],
        ];
        $this->db->where('id', $id);
        return $this->db->update($this->table, $updateData);
    }

    public function get_by_slug($slug) {
        return $this->db->where('slug', $slug)->get('tblhr_contract_email_templates')->row();
    }
}
