<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<style>
    /* Card-style comment container */
    .comment-wrapper {
        background: #fff;
        border: 1px solid #e0e0e0;
        border-radius: 10px;
        padding: 20px;
        margin-bottom: 20px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    }

    /* Dropzone styling */
    .dropzoneDragArea {
        border: 2px dashed #bbb;
        border-radius: 8px;
        background: #fafafa;
        text-align: center;
        padding: 30px;
        margin-top: 10px;
        transition: 0.3s;
    }
    .dropzoneDragArea:hover {
        border-color: #007bff;
        background: #f0f8ff;
    }

    .dz-details, .dz-error-mark, .dz-success-mark {
        display: none !important;
    }

    /* Tag input styling */
    .tag-input {
        display: flex;
        flex-wrap: wrap;
        border: 1px solid #ccc;
        border-radius: 6px;
        padding: 6px;
        min-height: 45px;
        background-color: #fff;
    }
    .tag-input__field {
        flex: 1;
        border: none;
        outline: none;
        padding: 6px;
        font-size: 14px;
    }
    .tag {
        background: #007bff;
        color: #fff;
        padding: 4px 10px;
        border-radius: 20px;
        margin: 4px;
        display: flex;
        align-items: center;
        font-size: 13px;
    }
    .tag button {
        border: none;
        background: transparent;
        color: #fff;
        margin-left: 6px;
        cursor: pointer;
        font-weight: bold;
    }

    /* Uploaded image preview tweak */
    .dz-preview img {
        max-width: 100px;
        border-radius: 6px;
        margin-top: 10px;
    }

    .tc-content p:empty::before {
    content: none; /* Removes the pseudo-element content */
}

</style>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>

                <div class="panel_s">
                    <div class="panel-body">
                        <?php if (!empty($candidate_projects) && is_array($candidate_projects)): ?>
                            <!-- Tab navigation -->
                            <ul class="nav nav-tabs" role="tablist">
                                <?php $i = 0; foreach ($candidate_projects as $project): ?>
                                    <li role="presentation" class="<?php echo $i === 0 ? 'active' : ''; ?>">
                                        <a href="#project-<?php echo $project->id; ?>" aria-controls="project-<?php echo $project->id; ?>" role="tab" data-toggle="tab">
                                            Project <?php echo ++$i; ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>

                            <!-- Tab content -->
                            <div class="tab-content" style="margin-top: 20px;">
                                <?php $i = 0; foreach ($candidate_projects as $project): ?>
                                    <div role="tabpanel" class="tab-pane <?php echo $i === 0 ? 'active' : ''; ?>" id="project-<?php echo $project->id; ?>">
                                        <form action="<?php echo admin_url('hr/assignment/process/' . $project->id); ?>" method="post">
                                            <div class="panel-body">

                                                <?php if (!empty($project->source_code)): ?>
                                                    <a href="<?php echo base_url($project->source_code); ?>" target="_blank" class="btn btn-sm btn-primary mright5">
                                                        View Source Code PDF
                                                    </a>
                                                <?php endif; ?>

                                                <?php if (!empty($project->report)): ?>
                                                    <a href="<?php echo base_url($project->report); ?>" target="_blank" class="btn btn-sm btn-primary mright5">
                                                        View Report PDF
                                                    </a>
                                                <?php endif; ?>

                                                <?php if (!empty($project->other)): ?>
                                                    <a href="<?php echo base_url($project->other); ?>" target="_blank" class="btn btn-sm btn-primary mright5">
                                                        View Other PDF
                                                    </a>
                                                <?php endif; ?>

                                                <br><br>

                                                <!-- Comment Textarea -->
                                                <!-- <div class="col-md-12">
                                                    <?php echo render_textarea(
                                                        'comment',
                                                        _l('Comments'),
                                                        '',
                                                        ['rows' => 6],
                                                        [],
                                                        '',
                                                        'tinymce'
                                                    ); ?>
                                                </div>

                                                <div class="col-md-12">
                                                    <label class="control-label">Upload Files</label>
                                                    <div id="dropzoneTaskComment" class="dropzoneDragArea dz-clickable">
                                                        <span>Drop files here or click to upload</span>
                                                    </div>
                                                    <input type="hidden" name="attachments" id="hiddenAttachments" />

                                                </div>

                                                <div class="col-md-12 mt-3">
                                                    <label class="control-label">Tags</label>
                                                    <div class="tag-input" id="tagInput">
                                                        <input id="tagInputField" class="tag-input__field" type="text" placeholder="Add a tag and press Enter or comma" />
                                                    </div>
                                                    <input type="hidden" name="tags" id="hiddenTags" />
                                                </div> -->
                                            </div>

                                            <div class="panel-footer text-right">
                                                <?php echo form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>
                                                <button type="submit" name="status" value="reject" class="btn btn-danger"><?php echo _l('Reject'); ?></button>
                                                <button type="submit" name="status" value="approve" class="btn btn-success"><?php echo _l('Approve'); ?></button>
                                                <!-- <button type="submit" name="status" value="comment" class="btn btn-info"><?php echo _l('Add Comment'); ?></button> -->
                                                <a href="<?php echo admin_url('hr/assignment'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                                            </div>
                                        </form>
                                    </div>
                                <?php $i++; endforeach; ?>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">No projects available for this candidate.</p>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="panel_s">
                    <div class="panel-body">
                        <?php if (!empty($candidate_projects) && is_array($candidate_projects)): ?>
                            <!-- Tab navigation -->
                            <!-- <ul class="nav nav-tabs" role="tablist">
                                <?php $i = 0; foreach ($candidate_projects as $project): ?>
                                    <li role="presentation" class="<?php echo $i === 0 ? 'active' : ''; ?>">
                                        <a href="#project-<?php echo $project->id; ?>" aria-controls="project-<?php echo $project->id; ?>" role="tab" data-toggle="tab">
                                            Project <?php echo ++$i; ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul> -->

                            <!-- Tab content -->
                            <div class="tab-content" style="margin-top: 20px;">
                                <?php $i = 0; foreach ($candidate_projects as $project): ?>
                                    <div role="tabpanel" class="tab-pane <?php echo $i === 0 ? 'active' : ''; ?>" id="project-<?php echo $project->id; ?>">
                                        <form action="<?php echo admin_url('hr/assignment/process/' . $project->id); ?>" method="post">
                                            <div class="panel-body">

                                                <!-- Comment Textarea -->
                                                <div class="col-md-12">
                                                    <?php echo render_textarea(
                                                        'comment',
                                                        _l('Comments'),
                                                        '',
                                                        ['rows' => 6],
                                                        [],
                                                        '',
                                                        'tinymce'
                                                    ); ?>
                                                </div>

                                                <div class="col-md-12">
                                                    <label class="control-label">Upload Files</label>
                                                    <div id="dropzoneTaskComment" class="dropzoneDragArea dz-clickable">
                                                        <span>Drop files here or click to upload</span>
                                                    </div>
                                                    <input type="hidden" name="attachments" id="hiddenAttachments" />

                                                </div>

                                                <div class="col-md-12 mt-3">
                                                    <label class="control-label">Tags</label>
                                                    <div class="tag-input" id="tagInput">
                                                        <input id="tagInputField" class="tag-input__field" type="text" placeholder="Add a tag and press Enter or comma" />
                                                    </div>
                                                    <input type="hidden" name="tags" id="hiddenTags" />
                                                </div>
                                            </div>

                                            <div class="panel-footer text-right">
                                                <?php echo form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>
                                                <button type="submit" name="status" value="comment" class="btn btn-info"><?php echo _l('Add Comment'); ?></button>
                                                <a href="<?php echo admin_url('hr/assignment'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                                            </div>
                                        </form>
                                    </div>
                                <?php $i++; endforeach; ?>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">No projects available for this candidate.</p>
                        <?php endif; ?>
                    </div>
                </div>


                <!-- <div id="task-comments" class="mtop10">
                    <?php if (!empty($assignment_comments)): ?>
                        <?php foreach ($assignment_comments as $comment): 
                            // Fetch staff info
                            $staff = get_staff_full_name($comment['staff_id']); // Perfex helper
                            $staff_img = staff_profile_image_url($comment['staff_id'], 'small'); // get small profile img
                            $comment_time = time_ago($comment['created_at']); // Perfex helper
                        ?>
                        <div id="comment_<?= $comment['id']; ?>" data-commentid="<?= $comment['id']; ?>" class="tc-content tw-group/comment task-comment highlight-bg" style="padding: 15px;">
                            <a data-task-comment-href-id="<?= $comment['id']; ?>" href="#comment_<?= $comment['id']; ?>" class="task-date-as-comment-id">
                                <span class="tw-text-sm">
                                    <span class="text-has-action inline-block" data-toggle="tooltip" data-title="<?= $comment['created_at']; ?>" title="">
                                        <?= $comment_time; ?>
                                    </span>
                                </span>
                            </a>
                            <a href="<?= admin_url('profile/' . $comment['staff_id']); ?>" target="_blank">
                                <img src="<?= $staff_img; ?>" class="staff-profile-image-small media-object img-circle pull-left mright10">
                            </a>
                            
                            <?php if ($comment['staff_id'] == get_staff_user_id() || is_admin()): ?>
                                <span class="pull-right tw-mx-2.5 group-hover/comment:tw-opacity-100 tw-opacity-0">
                                    <a href="javascript:void(0);" 
                                    class="delete-comment tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700"
                                    data-id="<?= $comment['id'] ?>">
                                    <i class="fa fa-trash-can"></i>
                                    </a>
                                </span>
                            <?php endif; ?>

                            <div class="media-body comment-wrapper">
                                <a href="<?= admin_url('profile/' . $comment['staff_id']); ?>" target="_blank"><?= $staff; ?></a> 
                                <div class="mleft40">
                                    <p><?= html_entity_decode($comment['comment']); ?></p>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p class="text-center text-muted mtop10"><?= _l('No comments yet'); ?></p>
                    <?php endif; ?>
                </div> -->

                <?php if (!empty($assignment_comments)): ?>
                    <?php foreach ($assignment_comments as $comment): 
                        $staff = get_staff_full_name($comment['staff_id']);
                        $staff_img = staff_profile_image_url($comment['staff_id'], 'small');
                        $comment_time = time_ago($comment['created_at']);

                        // Decode comment JSON safely
                        $commentData = json_decode($comment['comment'], true);
                        if (!is_array($commentData)) {
                            $commentData = [
                                'text' => $comment['comment'], 
                                'tags' => [], 
                                'attachments' => []
                            ];
                        }

                        $commentText = $commentData['text'] ?? '';
                        $commentTags = $commentData['tags'] ?? [];
                        $commentAttachments = $commentData['attachments'] ?? [];
                    ?>
                    <div id="comment_<?= $comment['id']; ?>" data-commentid="<?= $comment['id']; ?>" class="tc-content tw-group/comment task-comment highlight-bg" style="padding: 15px;">
                        <a data-task-comment-href-id="<?= $comment['id']; ?>" href="#comment_<?= $comment['id']; ?>" class="task-date-as-comment-id">
                            <span class="tw-text-sm">
                                <span class="text-has-action inline-block" data-toggle="tooltip" data-title="<?= $comment['created_at']; ?>" title="">
                                    <?= $comment_time; ?>
                                </span>
                            </span>
                        </a>
                        <a href="<?= admin_url('profile/' . $comment['staff_id']); ?>" target="_blank">
                            <img src="<?= $staff_img; ?>" class="staff-profile-image-small media-object img-circle pull-left mright10">
                        </a>

                        <?php if ($comment['staff_id'] == get_staff_user_id() || is_admin()): ?>
                            <span class="pull-right tw-mx-2.5 group-hover/comment:tw-opacity-100 tw-opacity-0">
                                <a href="javascript:void(0);" 
                                class="delete-comment tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700"
                                data-id="<?= $comment['id'] ?>">
                                <i class="fa fa-trash-can"></i>
                                </a>
                            </span>
                        <?php endif; ?>

                        <div class="media-body comment-wrapper">
                            <a href="<?= admin_url('profile/' . $comment['staff_id']); ?>" target="_blank"><?= $staff; ?></a> 
                            <div class="mleft40">
                                <!-- Comment text -->
                                <p><?= $commentText; ?></p>

                                <!-- Tags -->
                                <?php if (!empty($commentTags)): ?>
                                    <div class="comment-tags mbot5">Tag:
                                        <?php foreach ($commentTags as $tag): ?>
                                            <span class="badge badge-info"> <?= htmlspecialchars($tag); ?></span>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>

                                <!-- Attachments -->
                                <?php if (!empty($commentAttachments)): ?>
                                    <div class="comment-attachments"> Documents:
                                        <?php foreach ($commentAttachments as $file): 
                                            $filename = basename($file);
                                            $fileUrl = base_url($file); // adjust path if needed
                                        ?>
                                            <a href="<?= $fileUrl; ?>" target="_blank"><?= $filename; ?></a><br>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="text-center text-muted mtop10"><?= _l('No comments yet'); ?></p>
                <?php endif; ?>


                
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>


<script>
    const csrfName = '<?= $this->security->get_csrf_token_name(); ?>';
    const csrfHash = '<?= $this->security->get_csrf_hash(); ?>';

    document.querySelectorAll('.delete-comment').forEach(el => {
        el.addEventListener('click', function() {
            const commentId = this.dataset.id;
            if (confirm('Are you sure you want to delete this comment?')) {
                fetch('<?= admin_url('hr/assignment/delete_comment') ?>/' + commentId, {
                    method: 'POST',
                    headers: { 'X-Requested-With': 'XMLHttpRequest', 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: csrfName + '=' + csrfHash
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        this.closest('li, div, tr').remove();
                    } else {
                        alert(data.message || 'Failed to delete comment');
                    }
                });
            }
        });
    });
</script>


<script>
document.addEventListener('DOMContentLoaded', function () {
    const form = document.querySelector('form');
    const commentTextarea = document.querySelector('[name="comment"]');
    const tagInputField = document.getElementById('tagInputField');
    const tagHidden = document.getElementById('hiddenTags');
    const tagContainer = document.getElementById('tagInput');

    // 💾 Hidden field for attachments (add this in your form if missing)
    if (!document.getElementById('hiddenAttachments')) {
        const hiddenAttach = document.createElement('input');
        hiddenAttach.type = 'hidden';
        hiddenAttach.name = 'attachments';
        hiddenAttach.id = 'hiddenAttachments';
        form.appendChild(hiddenAttach);
    }

    let tags = [];
    let attachments = [];

    // ============ TAG SYSTEM ============
    function renderTags() {
        tagContainer.querySelectorAll('.tag-item').forEach(el => el.remove());
        tags.forEach((tag, index) => {
            const tagEl = document.createElement('span');
            tagEl.className = 'tag-item badge badge-info mright5';
            tagEl.innerHTML = `${tag} <span data-index="${index}" class="remove-tag" style="cursor:pointer;">×</span>`;
            tagContainer.insertBefore(tagEl, tagInputField);
        });
        tagHidden.value = JSON.stringify(tags);
    }

    tagInputField.addEventListener('keydown', function (e) {
        if (e.key === 'Enter' || e.key === ',') {
            e.preventDefault();
            const value = e.target.value.trim();
            if (value && !tags.includes(value)) {
                tags.push(value);
                renderTags();
            }
            e.target.value = '';
        }
    });

    tagContainer.addEventListener('click', function (e) {
        if (e.target.classList.contains('remove-tag')) {
            const index = parseInt(e.target.getAttribute('data-index'));
            tags.splice(index, 1);
            renderTags();
        }
    });

    // ============ DROPZONE ============
    // Dropzone.autoDiscover = false;
    // const dz = new Dropzone("#dropzoneTaskComment", {
    //     url: "#", // no upload; just capturing file names
    //     autoProcessQueue: false,
    //     addRemoveLinks: true,
    //     previewTemplate: `
    //         <div class="dz-preview dz-file-preview" style="border:none;background:none;">
    //             <img data-dz-thumbnail style="width:80px;height:80px;object-fit:cover;border-radius:8px;"/>
    //             <div data-dz-name style="font-size:12px;margin-top:4px;"></div>
    //         </div>
    //     `,
    //     init: function () {
    //         this.on("addedfile", function (file) {
    //             attachments.push(file.name);
    //             console.log('File added:', attachments);
    //         });
    //         this.on("removedfile", function (file) {
    //             attachments = attachments.filter(f => f !== file.name);
    //             console.log('File removed:', attachments);
    //         });
    //     }
    // });

    // ============ DROPZONE ============ 
    // let attachments = [];
    const attachHidden = document.getElementById('hiddenAttachments');

    Dropzone.autoDiscover = false;

    const dz = new Dropzone("#dropzoneTaskComment", {
        url: admin_url + "hr/assignment/upload_comment_attachment",
        paramName: "file",
        maxFilesize: 10,
        addRemoveLinks: true,
        init: function() {
            const dz = this;

            dz.on("sending", function(file, xhr, formData) {
                const csrfName = '<?php echo $this->security->get_csrf_token_name(); ?>';
                const csrfHash = '<?php echo $this->security->get_csrf_hash(); ?>';
                formData.append(csrfName, csrfHash);
            });

            dz.on("success", function(file, response) {
                try {
                    const res = typeof response === "string" ? JSON.parse(response) : response;
                    if (res.success && res.file && res.file.path) {
                        attachments.push(res.file.path);
                        attachHidden.value = JSON.stringify(attachments);
                        console.log("✅ Uploaded:", res.file.path);
                    } else {
                        console.error("⚠️ Upload failed:", res.error || "Unknown format");
                    }
                } catch(err) {
                    console.error("❌ Invalid JSON:", response);
                }
            });

            dz.on("removedfile", function(file) {
                attachments = attachments.filter(f => !f.includes(file.name));
                attachHidden.value = JSON.stringify(attachments);
                console.log("🗑 Removed:", file.name);
            });

            dz.on("error", function(file, msg, xhr) {
                console.error("❌ Dropzone error:", msg);
                if(xhr) console.error("HTTP status:", xhr.status, xhr.responseText);
            });
        }
    });




    // ============ FINAL SUBMIT ============
    form.addEventListener('submit', function () {
        const rawComment = tinymce.get(commentTextarea.id)?.getContent() || commentTextarea.value;

        const combinedData = {
            text: rawComment,
            tags: tags,
            attachments: attachments // ✅ fixed this variable
        };

        // 🔒 store JSON data inside comment field
        commentTextarea.value = JSON.stringify(combinedData);

        // also store attachments in hidden field for backend safety
        document.getElementById('hiddenAttachments').value = JSON.stringify(attachments);

        console.log("FINAL DATA:", combinedData);
    });
});
</script>






