<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <div class="_buttons mtop15">
                    <!-- <a href="<?php echo admin_url('hr/assignment/create'); ?>" class="btn btn-info">
                        <i class="fa-regular fa-plus tw-mr-1"></i>
                        <?php echo _l('hr_new_assignment'); ?>
                    </a> -->
                    <!-- <a href="<?php echo admin_url('hr/candidate'); ?>" class="btn btn-default">
                        <?php echo _l('hr_candidates'); ?>
                    </a> -->
                </div>

                <div class="panel_s tw-mt-2">
                    <div class="panel-body">
                        <?php  
                        $candidates = [];
                        foreach ($candidateproject as $row) {
                            $candidates[$row->candidate_name][] = $row;
                        }
                        ?>

                        <div class="table-responsive">
                            <table class="table dt-table table-assignments">
                                <thead>
                                    <tr>
                                        <th><?php echo _l('hr_candidate'); ?></th>
                                        <th><?php echo _l('hr_status'); ?></th>
                                        <th><?php echo _l('hr_submitted_at'); ?></th>
                                        <th><?php echo _l('hr_approved_at'); ?></th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($candidates as $candidate_name => $rows): ?>
                                        <!-- <?php
                                            $all_approved = true;
                                            $latest_status = null;

                                            foreach ($rows as $r) {
                                                $current_status = strtolower(trim($r->status));
                                                if ($current_status !== 'approved') {
                                                    $all_approved = false;
                                                    $latest_status = ucfirst($r->status);
                                                    break;
                                                }
                                            }

                                            // fallback to Approved if everything passed the check
                                            $status = $all_approved ? 'Approved' : ($latest_status ?? ucfirst($rows[0]->status));
                                            // var_dump($status); // Debugging line to check the status value
                                            $first = $rows[0];
                                            var_dump($first); // Debugging line to check the first row data
                                        ?>
                                         -->
                                        <?php
                                            // Make sure $rows is not empty
                                            if (!empty($rows)) {

                                                // Sort rows in ascending order by ID (or any field you prefer)
                                                usort($rows, function($a, $b) {
                                                    return $a->id <=> $b->id; // Replace 'id' with your sorting field
                                                });

                                                // Pick the first row in ascending order
                                                $first = $rows[0];

                                                // Check if all statuses are 'approved' (optional, keeps your original logic)
                                                $all_approved = true;
                                                $latest_status = null;

                                                foreach ($rows as $r) {
                                                    $current_status = strtolower(trim($r->status));
                                                    if ($current_status !== 'approved') {
                                                        $all_approved = false;
                                                        $latest_status = ucfirst($r->status);
                                                        break; // Stop at first non-approved
                                                    }
                                                }

                                                // Final status: either 'Approved' if all passed, else first non-approved, else first row status
                                                $status = $all_approved ? 'Approved' : ($latest_status ?? ucfirst($first->status));

                                                // Debugging output
                                                // var_dump($first);
                                                // var_dump($status);

                                            } else {
                                                $first = null;
                                                $status = null;
                                                echo "No rows found.";
                                            }
                                            ?>
                                        <tr>
                                            <td>
                                                <?php echo $candidate_name; ?>
                                                <div class="row-options">
                                                    <a href="<?php echo admin_url('hr/assignment/edit/' . $first->id); ?>" title="<?php echo _l('edit'); ?>">Edit</a>
                                                </div>
                                            </td>
                                            <td>
                                                <?php 
                                                    $badge_class = strtolower($status) === 'approved' ? 'success' : 
                                                                (strtolower($status) === 'rejected' ? 'danger' : 'warning');
                                                ?>
                                                <span class="label label-<?php echo $badge_class; ?>"><?php echo $status; ?></span>
                                            </td>
                                            <td><?php echo $first->created_at ? date('d-m-Y', strtotime($first->created_at)) : '-'; ?></td>
                                            <td><?php echo $first->approved_at ? date('d-m-Y', strtotime($first->approved_at)) : '-'; ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
