<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="panel_s">
    <div class="panel-heading">
        <h4 class="panel-title"><?= _l('Sign Contracts'); ?></h4>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th><?= _l('Contract Name'); ?></th>
                        <th><?= _l('Date'); ?></th>
                        <th class="text-right"><?= _l('Action'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($contracts)) : ?>
                        <?php foreach ($contracts as $contract): ?>
                            <tr>
                                <td><?= $contract->title; ?></td>
                                <td><?= date('D M d Y', strtotime($contract->candidate_created_by)); ?></td>
                                <td class="text-right">
                                    <a href="<?= site_url('hr/candidate_client/sign_contract/' . $contract->contract_id); ?>" 
                                    class="btn btn-info btn-sm">
                                        <?= _l('Sign'); ?>
                                    </a>
                                </td>


                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3" class="text-center"><?= _l('No contracts found'); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>

        </div>
    </div>
</div>





