<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="auth-container">
    <div class="row">
        <div class="col-md-6 col-md-offset-3">
            <div class="panel_s">
                <!-- <div class="panel-heading">
                    <h4 class="panel-title">
                        <?php //_l('Candidate Login'); ?>
                    </h4>
                </div> -->
                <div class="panel-body">
                    <?php
                        $current_url = current_url(); // Gets full current URL

                        // Decide action based on URL
                        $form_action = (strpos($current_url, 'hr/candidate_certificate/index') !== false) 
                            ? site_url('hr/candidate_certificate/check_otp') 
                            : site_url('hr/candidate_client/check_otp');
                    ?>
                <form method="post" action="<?= $form_action ?>">
                    <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" 
                            value="<?= $this->security->get_csrf_hash(); ?>" />
                        <!-- Candidate Name -->
                        <div class="form-group">
                            <label for="candidate_name"><?= _l('Name'); ?></label>
                            <input type="text" id="candidate_name" class="form-control" 
                                value="<?= isset($candidate) ? $candidate->first_name . ' ' . $candidate->last_name : '' ?>" readonly>
                        </div>

                        <!-- Candidate Email -->
                        <div class="form-group">
                            <label for="candidate_email"><?= _l('Email ID'); ?></label>
                            <input type="email" id="candidate_email" name="email" class="form-control" 
                                value="<?= isset($candidate) ? $candidate->email : '' ?>" readonly>
                        </div>

                        <!-- Hidden token -->
                        <input type="hidden" name="token" value="<?= $candidate->email_token ?? '' ?>" />

                        <!-- OTP Fields -->
                        <div class="form-group">
                            <label for="candidate_otp"><?= _l('OTP'); ?></label>
                            <div class="row">
                                <?php for($i=0; $i<6; $i++): ?>
                                    <div class="col-xs-2">
                                        <input type="text" maxlength="1" name="otp[]" class="form-control text-center" required />
                                    </div>
                                <?php endfor; ?>
                            </div>
                            <small class="text-muted"><?= _l('Enter OTP sent to above Email ID'); ?></small>
                        </div>

                        <!-- Buttons -->
                        <div class="form-group text-right">
                            <button type="submit" class="btn btn-info"><?= _l('Sign In'); ?></button>
                            <a href="<?= site_url(); ?>" class="btn btn-default"><?= _l('Cancel'); ?></a>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
