<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<style>
    .input-group-text {
    font-weight: 500;
    border-left: 0;
}
.input-group {
    display: flex;
}
.input-group-append {
    text-align: center;  
    padding: 5px;
    border: 1px solid #ced4da;
    background-color: #b0b6bd;
    border-radius: 0px 5px 5px 0px
}    
</style>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <?php echo form_open_multipart(); ?>
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="tab-content tw-mt-3">
                            <div role="tabpanel" class="tab-pane active" id="tab_candidate_info">
                                <div class="row">
                                    <div class="col-md-12">
                                        <span><b>Name: </b><?= isset($candidate) ? ($candidate->first_name.' '.$candidate->last_name) : 'Manya Gupta'; ?></span><br/>
                                        <span><b>Phone: </b><?= isset($candidate) ? $candidate->phone : '+91 12345 67890'; ?></span><br/>
                                        <span><b>Email: </b><?= isset($candidate) ? $candidate->email : 'manyagupta@gmail.com'; ?></span><br/>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12">
                                        <iframe src="<?= $pdf_url; ?>" style="width:100%; height:600px; border:1px solid #ddd;" frameborder="0"></iframe>
                                    </div>
                                </div>

                                <div class="row mb-4">
                                    <div class="col-md-6">
                                        <h3>Intern Info</h3>
                                        <?php if (!empty($fields_list) && is_array($fields_list)): ?>
                                            <?php foreach ($fields_list as $field): 
                                                $label  = $field['label'] ?? '';
                                                $name   = $field['name'] ?? strtolower(str_replace(' ', '_', $label)); // fallback unique key
                                                $type   = $field['type'] ?? 'text';
                                                $placeholder = $field['placeholder'] ?? '';
                                                $required = !empty($field['required']) ? 'required' : '';

                                                $value = '';
                                                if (!empty($candidate->intern_info)) {
                                                    $intern_data = json_decode($candidate->intern_info, true);
                                                    $value = $intern_data[$name] ?? '';
                                                }
                                            ?>
                                            <div class="mb-3">
                                                <label for="<?= $name ?>"><?= $label ?><?= $required ? ' *' : '' ?></label>

                                                <?php if ($type === 'textarea'): ?>
                                                    <textarea name="<?= $name ?>" id="<?= $name ?>" class="form-control" placeholder="<?= $placeholder ?>" <?= $required ?>><?= set_value($name, $value) ?></textarea>
                                                <?php elseif ($type === 'select' && isset($field['options']) && is_array($field['options'])): ?>
                                                    <select name="<?= $name ?>" id="<?= $name ?>" class="form-select" <?= $required ?>>
                                                        <option value="">Select <?= $label ?></option>
                                                        <?php foreach ($field['options'] as $option): ?>
                                                            <option value="<?= $option ?>" <?= $value == $option ? 'selected' : '' ?>><?= $option ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                <?php else: ?>
                                                    <input type="<?= $type ?>" name="<?= $name ?>" id="<?= $name ?>" class="form-control" value="<?= set_value($name, $value) ?>" placeholder="<?= $placeholder ?>" <?= $required ?>>
                                                <?php endif; ?>
                                            </div>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <p class="text-muted">No intern fields defined.</p>
                                        <?php endif; ?>
                                    </div>

                                    <!-- Company Info -->
                                    <div class="col-md-6">
                                        <h3>Company Info</h3>
                                        <?php 
                                            $company_value = !empty($candidate->company_info) ? $candidate->company_info : '';
                                            echo render_textarea('company_info', '', set_value('company_info', $company_value), ['rows' => 10], [], '', 'tinymce'); 
                                        ?>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="panel-footer text-right">
                        <button type="submit" class="btn btn-primary"><?= _l('submit'); ?></button>
                        <a href="<?= admin_url('hr/candidate'); ?>" class="btn btn-default"><?= _l('cancel'); ?></a>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>



