<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>

                <?php 
                    $form_action = admin_url('hr/certificate_template/create/' . (isset($certificate_template) ? $certificate_template->id : ''));
                    echo form_open_multipart($form_action, ['id' => 'certificate-template-form']); 
                ?>                                                                                                                                                                                  

                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo render_input('title', _l('hr_contract_title'), isset($certificate_template) ? $certificate_template->title : ''); ?>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <label for="">Characteristics</label><br>
                                <button type="button" class="btn btn-primary copyButton" data-value="$firstname">First Name</button>
                                <button type="button" class="btn btn-primary copyButton" data-value="$lastname">Last Name</button>
                                <button type="button" class="btn btn-primary copyButton" data-value="$projecttitle">Project Title</button>
                                <button type="button" class="btn btn-primary copyButton" data-value="$duration">Duration</button>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <?php echo render_textarea('details', _l(line: 'Details'), isset($certificate_template) ? $certificate_template->details : '', ['rows' => 10], [], '', 'tinymce'); ?>
                            </div>
                        </div>

                        <div class="row">                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="background_image" class="control-label"><?= _l('Background Image'); ?></label>
                                    <input type="file" name="background_image" class="form-control" id="background_image">
                                    
                                    <?php if (isset($certificate_template) && !empty($certificate_template->background_image)) { ?>
                                        <div class="mt-2">
                                            <p class="text-muted"><?= _l('Current Image'); ?>:</p>
                                            <img src="<?= base_url($certificate_template->background_image); ?>" 
                                                 alt="Certificate Background" 
                                                 class="img-thumbnail" 
                                                 style="max-width: 300px;">
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="panel-footer text-right">
                        <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                        <a href="<?php echo admin_url('hr/certificate_template'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                    </div>
                </div>

                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>

<script>
    $(document).ready(function () {
        $(".copyButton").click(function () {
            let textToCopy = $(this).data("value");

            navigator.clipboard.writeText(textToCopy).then(() => {
                // alert("Copied: " + textToCopy);
            }).catch(err => {
                console.error("Error copying text: ", err);
            });
        });
    });
</script>