<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <div class="_buttons mtop15">
                    <a href="<?php echo admin_url('hr/certification/create'); ?>" class="btn btn-info">
                        <i class="fa-regular fa-plus tw-mr-1"></i>
                        <?php echo _l('New Certification Template'); ?>
                    </a>
                    <!-- <a href="<?php echo admin_url('hr/candidate'); ?>" class="btn btn-default">
                        <?php echo _l('hr_candidates'); ?>
                    </a>
                    <a href="<?php echo admin_url('hr/certification/validate'); ?>" class="btn btn-success">
                        <i class="fa-regular fa-search"></i>
                        <?php echo _l('hr_validate_certificate'); ?>
                    </a> -->
                </div>

                <div class="panel_s tw-mt-2">
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table dt-table table-certifications">
                                <thead>
                                <tr>
                                    <th><?php echo 'Title'; ?></th>
                                    <th><?php echo 'Background Image'; ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($certifications as $row) { ?>
                                    <tr>
                                        <td>
                                            <?php echo e($row->title ?? 'N/A'); ?>
                                            <div class="row-options">
                                                <a href="<?php echo admin_url('hr/certificate_template/create/' . $row->id); ?>" title="<?php echo _l('edit'); ?>">Edit</a>| 
                                                <a href="<?php echo admin_url('hr/certificate_template/delete/' . $row->id); ?>" title="<?php echo _l('delete'); ?>">Delete</a>
                                            </div>
                                        </td>
                                        <td><?php if($row->background_image){ ?>
                                                <img src="<?php echo base_url($row->background_image); ?>" width="100">
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
