<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <div class="_buttons mtop15">
                    <a href="<?php echo admin_url('hr/department_designation/add_edit'); ?>" class="btn btn-info">
                        <i class="fa-regular fa-plus tw-mr-1"></i>
                        <?php echo _l('hr_new_department'); ?>
                    </a>
                </div>

                <div class="panel_s tw-mt-2">
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table dt-table table-departments">
                                <thead>
                                <tr>
                                    <th><?php echo 'Name'; ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($departments as $row) { ?>
                                    <tr>
                                        <td>
                                        <?php echo e($row['name'] ?? 'N/A'); ?>
                                            <div class="row-options">
                                                <a href="<?php echo admin_url('hr/department_designation/add_edit/' . $row['id']); ?>" title="<?php echo _l('edit'); ?>">Edit</a> |
                                                <a href="<?php echo admin_url('hr/department_designation/delete_department/' . $row['id']); ?>" title="<?php echo _l('delete'); ?>">Delete</a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
