<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Contract_template extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        if (!is_admin()) {
            access_denied('hr');
        }
        $this->load->model('hr/contract_template_model');
    }

    public function index()
    {
        $data['title'] = _l('hr_contracts');
        $data['contracts'] = $this->contract_template_model->all();
        $this->load->view('contract_template/manage', $data);
    }

    public function create()
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $contractData = [
                'title' => trim($post['title'] ?? ''),
                'details' => trim($post['details'] ?? ''),
                'created_by' => get_staff_user_id(),
            ];

            $id = $this->contract_template_model->add($contractData);
            if ($id) {
                set_alert('success', _l('added_successfully', _l('hr_contract')));
            }
            redirect(admin_url('hr/contract_template'));
        }

        $data['title'] = _l('hr_new_contract');
        $this->load->view('contract_template/add_edit', $data);
    }
    public function edit($id)
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);

            // collect dynamic fields
            $labels = $post['field_label'] ?? [];
            $values = $post['field_value'] ?? [];

            $fields = [];
            if (!empty($labels)) {
                foreach ($labels as $i => $label) {
                    $fields[] = [
                        'label' => $label,
                        'value' => $values[$i] ?? null,
                    ];
                }
            }

            $contractData = [
                'title'       => trim($post['title'] ?? ''),
                'details'     => trim($post['details'] ?? ''),
                'fields_list' => json_encode($fields), // store JSON in fields_list
            ];

            $success = $this->contract_template_model->update($id, $contractData);
            if ($success) {
                set_alert('success', _l('updated_successfully', _l('hr_contract')));
            }
            redirect(admin_url('hr/contract_template'));
        }

        $data['contract_template'] = $this->contract_template_model->get($id);
        if (!$data['contract_template']) {
            show_404();
        }

        // decode fields_list for editing
        $data['contract_template_fields'] = [];
        if (!empty($data['contract_template']->fields_list)) {
            $data['contract_template_fields'] = json_decode($data['contract_template']->fields_list);
        }

        $data['title'] = _l('hr_edit_contract');
        $this->load->view('contract_template/add_edit', $data);
    }



    public function delete($id)
    {
        $this->contract_template_model->delete($id);
        set_alert('success', _l('deleted', _l('hr_contract')));
        redirect(admin_url('hr/contract_template'));
    }
}
