<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Assignment_model extends App_Model
{
    protected $table = '';

    public function __construct()
    {
        parent::__construct();
        $this->table = db_prefix() . 'hr_assignments';
    }

    public function all($where = [])
    {
        if (!empty($where)) {
            $this->db->where($where);
        }
        $this->db->select('c.*, candidate.first_name, candidate.last_name');
        $this->db->from($this->table . ' c');
        $this->db->join(db_prefix() . 'hr_candidates candidate', 'c.candidate_id = candidate.id', 'left');
        $this->db->order_by('c.id', 'DESC');
        return $this->db->get($this->table)->result_array();
    }

    public function get($id)
    {
        $this->db->where('id', $id);
        return $this->db->get($this->table)->row();
    }

    public function add($data)
    {
        $data['created_at'] = date('Y-m-d H:i:s');
        $data['updated_at'] = date('Y-m-d H:i:s');
        $this->db->insert($this->table, $data);
        return (int) $this->db->insert_id();
    }

    public function update($id, $data)
    {
        $data['updated_at'] = date('Y-m-d H:i:s');
        $this->db->where('id', $id);
        return $this->db->update($this->table, $data);
    }

    public function delete($id)
    {
        $this->db->where('id', $id);
        $this->db->delete($this->table);
        return (int) $this->db->affected_rows();
    }

    public function get_by_candidate($candidate_id)
    {
        $this->db->where('candidate_id', $candidate_id);
        $this->db->order_by('id', 'DESC');
        return $this->db->get($this->table)->result_array();
    }

    public function approve($id)
    {
        $data = [
            'status' => 'approved',
            'approved_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        ];
        $this->db->where('id', $id);
        return $this->db->update($this->table, $data);
    }

    public function reject($id)
    {
        $data = [
            'status' => 'rejected',
            'updated_at' => date('Y-m-d H:i:s')
        ];
        $this->db->where('id', $id);
        return $this->db->update($this->table, $data);
    }
}
