<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Contract_model extends App_Model
{
    protected $table = '';

    public function __construct()
    {
        parent::__construct();
        $this->table = db_prefix() . 'hr_contracts';
    }


    public function all($where = [])
    {
        if (!empty($where)) {
            $this->db->where($where);
        }
        
        $this->db->select('cc.*,c.title, c.details, c.first_page, c.background_page, c.last_page, c.fields_list,ca.first_name, ca.last_name, ca.email, ca.phone, ca.created_by as candidate_created_by, CONCAT(s.firstname, " ", s.lastname) as created_by_name, ca.valid_date');
        $this->db->from(db_prefix() . 'hr_candidate_contracts as cc');
        $this->db->join(db_prefix() . 'hr_contracts as c', 'c.id = cc.contract_id', 'inner');
        $this->db->join(db_prefix() . 'hr_candidates as ca', 'ca.id = cc.candidate_id', 'inner');   
        $this->db->join(db_prefix() . 'staff s', 's.staffid = c.created_by', 'left');
        return $this->db->get()->result_array();
    }

    public function get($id)
    {
        $this->db->where('id', $id);
        return $this->db->get($this->table)->row();
    }

    public function add($data)
    {
        $data['created_at'] = date('Y-m-d H:i:s');
        $data['updated_at'] = date('Y-m-d H:i:s');
        $this->db->insert($this->table, $data);
        return (int) $this->db->insert_id();
    }

    public function update($id, $data)
    {
        $data['updated_at'] = date('Y-m-d H:i:s');
        $this->db->where('id', $id);
        return $this->db->update($this->table, $data);
    }

    public function delete($id)
    {
        $this->db->where('id', $id);
        $this->db->delete($this->table);
        return (int) $this->db->affected_rows();
    }
}
