<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<style>
.calendar-filters {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 5px;
    margin-bottom: 20px;
}

.checkbox-group {
    margin-top: 10px;
}

.checkbox-group label {
    margin-right: 15px;
    font-weight: normal;
}

.checkbox-group input[type="checkbox"] {
    margin-right: 5px;
}

.summary-card {
    display: flex;
    align-items: center;
    padding: 15px;
    background: #fff;
    border-radius: 5px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    margin-bottom: 15px;
}

.summary-icon {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 15px;
    color: white;
}

.summary-icon i {
    font-size: 20px;
}

.summary-content h3 {
    margin: 0;
    font-size: 24px;
    font-weight: bold;
    color: #333;
}

.summary-content p {
    margin: 0;
    color: #666;
    font-size: 14px;
}

.bg-primary { background-color: #007bff !important; }
.bg-success { background-color: #28a745 !important; }
.bg-warning { background-color: #ffc107 !important; }
.bg-info { background-color: #17a2b8 !important; }

/* FullCalendar Custom Styling */
.fc {
    font-family: inherit;
}

.fc-event {
    border-radius: 4px !important;
    border: none !important;
    font-size: 12px !important;
    padding: 3px 6px !important;
    cursor: pointer;
    transition: all 0.2s ease;
}

.fc-event:hover {
    transform: scale(1.02);
    box-shadow: 0 2px 8px rgba(0,0,0,0.15);
}

.fc-event-title {
    font-weight: 600;
    font-size: 11px;
}

/* Custom event colors for different statuses */
.fc-event.regular-event {
    background-color: #4caf50 !important;
    color: white !important;
}

.fc-event.overtime-event {
    background-color: #ff9800 !important;
    color: white !important;
}

.fc-event.holiday-event {
    background-color: #ffeb3b !important;
    color: #333 !important;
}

.fc-event.vacation-event {
    background-color: #2196f3 !important;
    color: white !important;
}

.fc-event.sick-leave-event {
    background-color: #f44336 !important;
    color: white !important;
}

/* Calendar header styling */
.fc-toolbar {
    margin-bottom: 20px !important;
    padding: 10px 0;
}

.fc-button {
    background-color: #007bff !important;
    border-color: #007bff !important;
    color: white !important;
    border-radius: 4px !important;
    padding: 6px 12px !important;
    font-size: 14px !important;
    font-weight: 500 !important;
}

.fc-button:hover {
    background-color: #0056b3 !important;
    border-color: #0056b3 !important;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.fc-button-active {
    background-color: #0056b3 !important;
    border-color: #0056b3 !important;
}

.fc-button-group > .fc-button {
    margin-right: 2px;
}

/* Calendar grid styling */
.fc-daygrid-day {
    border: 1px solid #e9ecef;
}

.fc-daygrid-day-number {
    padding: 8px;
    font-weight: 500;
}

.fc-day-today {
    background-color: #e3f2fd !important;
}

.fc-daygrid-day-events {
    margin-top: 2px;
}

/* Calendar title */
.fc-toolbar-title {
    font-size: 1.5rem !important;
    font-weight: 600 !important;
    color: #333 !important;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .summary-card {
        margin-bottom: 10px;
    }
    
    .checkbox-group label {
        display: block;
        margin-bottom: 5px;
    }
    
    .btn-group .btn {
        margin-bottom: 5px;
    }
}
</style>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <!-- Calendar Filters -->
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="calendar-filters">
                                    <h4 class="mb-3">Timesheet Calendar</h4>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Filter by Status:</label>
                                                <div class="checkbox-group">
                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" name="regular" checked> Regular Work
                                                    </label>
                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" name="overtime" checked> Overtime
                                                    </label>
                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" name="holiday" checked> Holiday
                                                    </label>
                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" name="vacation" checked> Vacation
                                                    </label>
                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" name="sick_leave" checked> Sick Leave
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Quick Actions:</label>
                                                <div class="btn-group">
                                                    <button type="button" class="btn btn-sm btn-primary" onclick="calendar.gotoDate(new Date())">Today</button>
                                                    <button type="button" class="btn btn-sm btn-info" onclick="calendar.changeView('dayGridMonth')">Month</button>
                                                    <button type="button" class="btn btn-sm btn-info" onclick="calendar.changeView('timeGridWeek')">Week</button>
                                                    <button type="button" class="btn btn-sm btn-info" onclick="calendar.changeView('timeGridDay')">Day</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Calendar Container -->
                        <div id="calendar1"></div>
                        
                        <!-- Timesheet Summary -->
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Timesheet Summary</h4>
                                    </div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="summary-card">
                                                    <div class="summary-icon bg-primary">
                                                        <i class="fa fa-clock-o"></i>
                                                    </div>
                                                    <div class="summary-content">
                                                        <h3 id="total-hours">0</h3>
                                                        <p>Total Hours</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="summary-card">
                                                    <div class="summary-icon bg-success">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <div class="summary-content">
                                                        <h3 id="days-worked">0</h3>
                                                        <p>Days Worked</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="summary-card">
                                                    <div class="summary-icon bg-warning">
                                                        <i class="fa fa-clock-o"></i>
                                                    </div>
                                                    <div class="summary-content">
                                                        <h3 id="overtime-hours">0</h3>
                                                        <p>Overtime Hours</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="summary-card">
                                                    <div class="summary-icon bg-info">
                                                        <i class="fa fa-percent"></i>
                                                    </div>
                                                    <div class="summary-content">
                                                        <h3 id="avg-hours">0</h3>
                                                        <p>Avg Daily Hours</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>

<!-- ✅ FullCalendar Assets -->
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.js"></script>

<script>
$(function() {
//   setTimeout(function() {
    console.log("✅ Calendar initializing after delay...");
    const now = new Date();
    const year = now.getFullYear();
    const month = String(now.getMonth() + 1).padStart(2, '0');

    const events = [
      { title: '8h - Regular', start: `${year}-${month}-02`, className: 'regular-event', url: '<?php echo admin_url('virtual_office/virtual_office/day_report'); ?>' },
      { title: '8.5h - Regular', start: `${year}-${month}-03`, className: 'regular-event', url: '<?php echo admin_url('virtual_office/virtual_office/day_report'); ?>' },
      { title: '9h - Overtime', start: `${year}-${month}-05`, className: 'overtime-event', url: '<?php echo admin_url('virtual_office/virtual_office/day_report'); ?>' },
      { title: '8h - Regular', start: `${year}-${month}-06`, className: 'regular-event', url: '<?php echo admin_url('virtual_office/virtual_office/day_report'); ?>' },
      { title: '8.5h - Regular', start: `${year}-${month}-07`, className: 'regular-event', url: '<?php echo admin_url('virtual_office/virtual_office/day_report'); ?>' },
    ];

    const calendarEl = document.getElementById('calendar1');
    if (!calendarEl) return console.error("Calendar element not found");

    const calendar = new FullCalendar.Calendar(calendarEl, {
      initialView: 'dayGridMonth',
      headerToolbar: {
        left: 'prev,next today',
        center: 'title',
        right: ''
      },
      events: events,
    });
    calendar.render();
//   }, 300); // wait 300ms for DOM load
});
</script>
</body>
</html>
