<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Email_templates extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('email_template_model');
    }

    // List all contract email templates
    public function index()
    {
        $data['title'] = _l('Contract Email Templates');
        $data['templates'] = $this->email_template_model->get_templates();
        $this->load->view('email_templates/manage', $data);
    }

    // Edit template
    public function edit($id)
    {
        if ($this->input->post()) {
            $success = $this->email_template_model->update($id, $this->input->post());
            if ($success) {
                set_alert('success', _l('Template updated successfully.'));
            } else {
                set_alert('warning', _l('No changes made.'));
            }
            redirect(admin_url('hr/email_templates'));
        }

        $data['template'] = $this->email_template_model->get($id);
        $data['title']    = _l('Edit Template');
        $this->load->view('email_templates/edit', $data);
    }
}
