<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <?php echo form_open(); ?>
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="alert alert-info">
                                    <h4><i class="fa fa-info-circle"></i> <?php echo _l('hr_enable_login_info'); ?></h4>
                                    <p><?php echo _l('hr_enable_login_description'); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <h5><?php echo _l('hr_candidate_info'); ?></h5>
                                <table class="table table-condensed">
                                    <tr>
                                        <td><strong><?php echo _l('hr_candidate_name'); ?>:</strong></td>
                                        <td><?php echo e($candidate->first_name . ' ' . $candidate->last_name); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo _l('hr_candidate_email'); ?>:</strong></td>
                                        <td><?php echo e($candidate->email); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo _l('hr_candidate_type'); ?>:</strong></td>
                                        <td><?php echo e(ucfirst($candidate->candidate_type)); ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <h5><?php echo _l('hr_select_staff_account'); ?></h5>
                                <?php echo render_select('staff_id', array_map(function($staff){return ['id'=>$staff['staffid'],'name'=>$staff['firstname'].' '.$staff['lastname'].' ('.$staff['email'].')'];}, $staff), ['id','name'], _l('hr_staff_member'), ''); ?>
                                <small class="text-muted"><?php echo _l('hr_staff_selection_help'); ?></small>
                            </div>
                        </div>
                    </div>
                    <div class="panel-footer text-right">
                        <button type="submit" class="btn btn-success">
                            <i class="fa-regular fa-user-plus"></i> <?php echo _l('hr_enable_login'); ?>
                        </button>
                        <a href="<?php echo admin_url('hr/candidate/view/' . $candidate->id); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
