<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <div class="_buttons mtop15">
                    <a href="<?php echo admin_url('hr/candidate/create'); ?>" class="btn btn-info">
                        <i class="fa-regular fa-plus tw-mr-1"></i>
                        <?php echo _l('hr_new_candidate'); ?>
                    </a>
                    <a href="<?php echo admin_url('hr/contract'); ?>" class="btn btn-default">
                        <?php echo _l('hr_contracts'); ?>
                    </a>
                    <a href="<?php echo admin_url('hr/assignment'); ?>" class="btn btn-default">
                        <?php echo _l('hr_assignments'); ?>
                    </a>
                    <a href="<?php echo admin_url('hr/certification'); ?>" class="btn btn-default">
                        <?php echo _l('hr_certifications'); ?>
                    </a>
                </div>

                <!-- Filters -->
                <div class="panel_s tw-mt-2">
                    <div class="panel-body">
                        <?php echo form_open(admin_url('hr/candidate'), 'method="get"'); ?>
                        <div class="row">
                            <div class="col-md-3">
                                <?php echo render_select('candidate_type', [
                                    ['id' => '', 'name' => _l('hr_all_types')],
                                    ['id' => 'permanent', 'name' => _l('hr_candidate_type_permanent')],
                                    ['id' => 'freelancer', 'name' => _l('hr_candidate_type_freelancer')],
                                    ['id' => 'intern', 'name' => _l('hr_candidate_type_intern')],
                                    ['id' => 'contract', 'name' => _l('hr_candidate_type_contract')],
                                ], ['id', 'name'], _l('hr_candidate_type'), $filters['candidate_type'] ?? ''); ?>
                            </div>
                            <div class="col-md-3">
                                <?php echo render_select('status', [
                                    ['id' => '', 'name' => _l('hr_all_statuses')],
                                    ['id' => 'applied', 'name' => _l('hr_status_applied')],
                                    ['id' => 'shortlisted', 'name' => _l('hr_status_shortlisted')],
                                    ['id' => 'interview', 'name' => _l('hr_status_interview')],
                                    ['id' => 'selected', 'name' => _l('hr_status_selected')],
                                    ['id' => 'rejected', 'name' => _l('hr_status_rejected')],
                                ], ['id', 'name'], _l('hr_status'), $filters['status'] ?? ''); ?>
                            </div>
                            <div class="col-md-4">
                                <?php echo render_input('search', _l('search'), $filters['search'] ?? ''); ?>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary btn-block"><?php echo _l('filter'); ?></button>
                            </div>
                        </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>

                <div class="panel_s tw-mt-2">
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table dt-table table-candidates">
                                <thead>
                                <tr>
                                    <!-- <th>#</th> -->
                                    <th><?php echo _l('hr_candidate_name'); ?></th>
                                    <th><?php echo _l('hr_candidate_type'); ?></th>
                                    <th><?php echo _l('hr_candidate_email'); ?></th>
                                    <th><?php echo _l('hr_candidate_phone'); ?></th>
                                    <th><?php echo _l('hr_candidate_position'); ?></th>
                                    <th><?php echo _l('hr_status'); ?></th>
                                    <?php /*
                                    <th><?php echo _l('hr_login_status'); ?></th>
                                    <th></th>
                                    */ ?>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $i=1; ?>
                                <?php foreach ($candidates as $row) { ?>
                                    <tr>
                                        <?php /*
                                        <td><?php echo e($i); ?></td>
                                        */ ?>
                                        <td>
                                            <a href="<?php echo admin_url('hr/candidate/view/' . $row['id']); ?>">
                                                <?php echo e($row['first_name'] . ' ' . $row['last_name']); ?>
                                            </a>
                                            <div class="row-options">
                                                <a href="<?php echo admin_url('hr/candidate/edit/' . $row['id']); ?>" title="<?php echo _l('edit'); ?>">Edit</a> | 
                                                <a href="<?php echo admin_url('hr/candidate/delete/' . $row['id']); ?>" title="<?php echo _l('delete'); ?>">Delete</a>
                                            </div>
                                            <?php /* if ($row['staff_firstname']) { ?>
                                                <br><small class="text-muted">Staff: <?php echo e($row['staff_firstname'] . ' ' . $row['staff_lastname']); ?></small>
                                            <?php } */ ?>
                                            <?php /* <a href="<?php echo admin_url('hr/candidate/view/' . $row['id']); ?>" title="<?php echo _l('view'); ?>">View</a> | */ ?>
                                        </td>
                                        <td><span class="label label-info"><?php echo e(ucfirst($row['candidate_type'])); ?></span></td>
                                        <td><?php echo e($row['email']); ?></td>
                                        <td><?php echo e($row['phone']); ?></td>
                                        <td><?php echo e($row['position_applied']); ?></td>
                                        <td><span class="label label-default"><?php echo e(ucfirst($row['status'])); ?></span></td>
                                        <?php /*
                                        <td>
                                            <?php if ($row['can_login']) { ?>
                                                <span class="label label-success"><?php echo _l('hr_can_login'); ?></span>
                                            <?php } else { ?>
                                                <span class="label label-default"><?php echo _l('hr_cannot_login'); ?></span>
                                            <?php } ?>
                                        </td>
                                        <td class="text-right">
                                            <a href="<?php echo admin_url('hr/candidate/view/' . $row['id']); ?>" class="btn btn-info btn-icon" title="<?php echo _l('view'); ?>"><i class="fa-regular fa-eye"></i></a>
                                            <a href="<?php echo admin_url('hr/candidate/edit/' . $row['id']); ?>" class="btn btn-default btn-icon" title="<?php echo _l('edit'); ?>"><i class="fa-regular fa-pen-to-square"></i></a>
                                            <?php if (!$row['can_login']) { ?>
                                                <a href="<?php echo admin_url('hr/candidate/enable_login/' . $row['id']); ?>" class="btn btn-success btn-icon" title="<?php echo _l('hr_enable_login'); ?>"><i class="fa-regular fa-user-plus"></i></a>
                                            <?php } else { ?>
                                                <a href="<?php echo admin_url('hr/candidate/disable_login/' . $row['id']); ?>" class="btn btn-warning btn-icon" title="<?php echo _l('hr_disable_login'); ?>"><i class="fa-regular fa-user-minus"></i></a>
                                            <?php } ?>
                                            <a href="<?php echo admin_url('hr/candidate/delete/' . $row['id']); ?>" class="btn btn-danger btn-icon _delete" title="<?php echo _l('delete'); ?>"><i class="fa-regular fa-trash-can"></i></a>
                                        </td>*/ ?>
                                    </tr>
                                <?php $i++; ?>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
