<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <div class="_buttons mtop15">
                    <a href="<?php echo admin_url('hr/certification/create'); ?>" class="btn btn-info">
                        <i class="fa-regular fa-plus tw-mr-1"></i>
                        <?php echo _l('hr_new_certification'); ?>
                    </a>
                    <a href="<?php echo admin_url('hr/candidate'); ?>" class="btn btn-default">
                        <?php echo _l('hr_candidates'); ?>
                    </a>
                    <a href="<?php echo admin_url('hr/certification/validate'); ?>" class="btn btn-success">
                        <i class="fa-regular fa-search"></i>
                        <?php echo _l('hr_validate_certificate'); ?>
                    </a>
                </div>

                <div class="panel_s tw-mt-2">
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table dt-table table-certifications">
                                <thead>
                                <tr>
                                    <th><?php echo _l('hr_candidate'); ?></th>
                                    <th><?php echo _l('hr_certificate_number'); ?></th>
                                    <th><?php echo _l('hr_issued_at'); ?></th>
                                    <th><?php echo _l('hr_expires_at'); ?></th>
                                    <th><?php echo _l('hr_status'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($certifications as $row) { ?>
                                    <tr>
                                        <td>
                                            <?php echo e($row['first_name'] . ' ' . $row['last_name'] ?? 'N/A'); ?>
                                            <div class="row-options">
                                                <a href="<?php echo admin_url('hr/certification/edit/' . $row['id']); ?>" title="<?php echo _l('edit'); ?>">Edit</a> | 
                                                <a href="<?php echo admin_url('hr/certification/delete/' . $row['id']); ?>" title="<?php echo _l('delete'); ?>">Delete</a>
                                            </div>
                                        </td>
                                        <td><?php echo e($row['certificate_number']); ?></td>
                                        <td><?php echo e($row['issued_at'] ? _d($row['issued_at']) : '-'); ?></td>
                                        <td><?php echo e($row['expires_at'] ? _d($row['expires_at']) : '-'); ?></td>
                                        <td><span class="label label-default"><?php echo e(ucfirst($row['status'])); ?></span></td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
